package zio.aws.servicecatalog.model
import scala.jdk.CollectionConverters._
sealed trait PropertyKey {
  def unwrap: software.amazon.awssdk.services.servicecatalog.model.PropertyKey
}
object PropertyKey {
  def wrap(
      value: software.amazon.awssdk.services.servicecatalog.model.PropertyKey
  ): zio.aws.servicecatalog.model.PropertyKey = value match {
    case software.amazon.awssdk.services.servicecatalog.model.PropertyKey.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.servicecatalog.model.PropertyKey.OWNER =>
      val r = OWNER
      r
    case software.amazon.awssdk.services.servicecatalog.model.PropertyKey.LAUNCH_ROLE =>
      val r = LAUNCH_ROLE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.servicecatalog.model.PropertyKey {
    override def unwrap
        : software.amazon.awssdk.services.servicecatalog.model.PropertyKey =
      software.amazon.awssdk.services.servicecatalog.model.PropertyKey.UNKNOWN_TO_SDK_VERSION
  }
  case object OWNER extends zio.aws.servicecatalog.model.PropertyKey {
    override def unwrap
        : software.amazon.awssdk.services.servicecatalog.model.PropertyKey =
      software.amazon.awssdk.services.servicecatalog.model.PropertyKey.OWNER
  }
  case object LAUNCH_ROLE extends zio.aws.servicecatalog.model.PropertyKey {
    override def unwrap
        : software.amazon.awssdk.services.servicecatalog.model.PropertyKey =
      software.amazon.awssdk.services.servicecatalog.model.PropertyKey.LAUNCH_ROLE
  }
}
