package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.servicecatalog.model.primitives.{
  AcceptLanguage,
  ExecutionParameterKey,
  IdempotencyToken,
  ExecutionParameterValue,
  Id
}
import scala.jdk.CollectionConverters._
final case class ExecuteProvisionedProductServiceActionRequest(
    provisionedProductId: Id,
    serviceActionId: Id,
    executeToken: IdempotencyToken,
    acceptLanguage: Optional[AcceptLanguage] = Optional.Absent,
    parameters: Optional[
      Map[ExecutionParameterKey, Iterable[ExecutionParameterValue]]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.ExecuteProvisionedProductServiceActionRequest = {
    import ExecuteProvisionedProductServiceActionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.ExecuteProvisionedProductServiceActionRequest
      .builder()
      .provisionedProductId(Id.unwrap(provisionedProductId): java.lang.String)
      .serviceActionId(Id.unwrap(serviceActionId): java.lang.String)
      .executeToken(IdempotencyToken.unwrap(executeToken): java.lang.String)
      .optionallyWith(
        acceptLanguage.map(value =>
          AcceptLanguage.unwrap(value): java.lang.String
        )
      )(_.acceptLanguage)
      .optionallyWith(
        parameters.map(value =>
          value
            .map({ case (key, value) =>
              (ExecutionParameterKey
                .unwrap(key): java.lang.String) -> value.map { item =>
                ExecutionParameterValue.unwrap(item): java.lang.String
              }.asJavaCollection
            })
            .asJava
        )
      )(_.parameters)
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.ExecuteProvisionedProductServiceActionRequest.ReadOnly =
    zio.aws.servicecatalog.model.ExecuteProvisionedProductServiceActionRequest
      .wrap(buildAwsValue())
}
object ExecuteProvisionedProductServiceActionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.ExecuteProvisionedProductServiceActionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.servicecatalog.model.ExecuteProvisionedProductServiceActionRequest =
      zio.aws.servicecatalog.model
        .ExecuteProvisionedProductServiceActionRequest(
          provisionedProductId,
          serviceActionId,
          executeToken,
          acceptLanguage.map(value => value),
          parameters.map(value => value)
        )
    def provisionedProductId: Id
    def serviceActionId: Id
    def executeToken: IdempotencyToken
    def acceptLanguage: Optional[AcceptLanguage]
    def parameters
        : Optional[Map[ExecutionParameterKey, List[ExecutionParameterValue]]]
    def getProvisionedProductId: ZIO[Any, Nothing, Id] =
      ZIO.succeed(provisionedProductId)
    def getServiceActionId: ZIO[Any, Nothing, Id] = ZIO.succeed(serviceActionId)
    def getExecuteToken: ZIO[Any, Nothing, IdempotencyToken] =
      ZIO.succeed(executeToken)
    def getAcceptLanguage: ZIO[Any, AwsError, AcceptLanguage] =
      AwsError.unwrapOptionField("acceptLanguage", acceptLanguage)
    def getParameters: ZIO[Any, AwsError, Map[ExecutionParameterKey, List[
      ExecutionParameterValue
    ]]] = AwsError.unwrapOptionField("parameters", parameters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.ExecuteProvisionedProductServiceActionRequest
  ) extends zio.aws.servicecatalog.model.ExecuteProvisionedProductServiceActionRequest.ReadOnly {
    override val provisionedProductId: Id =
      zio.aws.servicecatalog.model.primitives.Id(impl.provisionedProductId())
    override val serviceActionId: Id =
      zio.aws.servicecatalog.model.primitives.Id(impl.serviceActionId())
    override val executeToken: IdempotencyToken =
      zio.aws.servicecatalog.model.primitives
        .IdempotencyToken(impl.executeToken())
    override val acceptLanguage: Optional[AcceptLanguage] =
      zio.aws.core.internal
        .optionalFromNullable(impl.acceptLanguage())
        .map(value =>
          zio.aws.servicecatalog.model.primitives.AcceptLanguage(value)
        )
    override val parameters
        : Optional[Map[ExecutionParameterKey, List[ExecutionParameterValue]]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.parameters())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.servicecatalog.model.primitives
                .ExecutionParameterKey(key) -> value.asScala.map { item =>
                zio.aws.servicecatalog.model.primitives
                  .ExecutionParameterValue(item)
              }.toList
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.ExecuteProvisionedProductServiceActionRequest
  ): zio.aws.servicecatalog.model.ExecuteProvisionedProductServiceActionRequest.ReadOnly =
    new Wrapper(impl)
}
