package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ProvisioningArtifactView(
    productViewSummary: Optional[
      zio.aws.servicecatalog.model.ProductViewSummary
    ] = Optional.Absent,
    provisioningArtifact: Optional[
      zio.aws.servicecatalog.model.ProvisioningArtifact
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.ProvisioningArtifactView = {
    import ProvisioningArtifactView.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.ProvisioningArtifactView
      .builder()
      .optionallyWith(productViewSummary.map(value => value.buildAwsValue()))(
        _.productViewSummary
      )
      .optionallyWith(provisioningArtifact.map(value => value.buildAwsValue()))(
        _.provisioningArtifact
      )
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.ProvisioningArtifactView.ReadOnly =
    zio.aws.servicecatalog.model.ProvisioningArtifactView.wrap(buildAwsValue())
}
object ProvisioningArtifactView {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.ProvisioningArtifactView
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicecatalog.model.ProvisioningArtifactView =
      zio.aws.servicecatalog.model.ProvisioningArtifactView(
        productViewSummary.map(value => value.asEditable),
        provisioningArtifact.map(value => value.asEditable)
      )
    def productViewSummary
        : Optional[zio.aws.servicecatalog.model.ProductViewSummary.ReadOnly]
    def provisioningArtifact
        : Optional[zio.aws.servicecatalog.model.ProvisioningArtifact.ReadOnly]
    def getProductViewSummary: ZIO[
      Any,
      AwsError,
      zio.aws.servicecatalog.model.ProductViewSummary.ReadOnly
    ] = AwsError.unwrapOptionField("productViewSummary", productViewSummary)
    def getProvisioningArtifact: ZIO[
      Any,
      AwsError,
      zio.aws.servicecatalog.model.ProvisioningArtifact.ReadOnly
    ] = AwsError.unwrapOptionField("provisioningArtifact", provisioningArtifact)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.ProvisioningArtifactView
  ) extends zio.aws.servicecatalog.model.ProvisioningArtifactView.ReadOnly {
    override val productViewSummary
        : Optional[zio.aws.servicecatalog.model.ProductViewSummary.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.productViewSummary())
        .map(value =>
          zio.aws.servicecatalog.model.ProductViewSummary.wrap(value)
        )
    override val provisioningArtifact
        : Optional[zio.aws.servicecatalog.model.ProvisioningArtifact.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.provisioningArtifact())
        .map(value =>
          zio.aws.servicecatalog.model.ProvisioningArtifact.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.ProvisioningArtifactView
  ): zio.aws.servicecatalog.model.ProvisioningArtifactView.ReadOnly =
    new Wrapper(impl)
}
