package zio.aws.servicecatalog.model
import zio.aws.servicecatalog.model.primitives.{
  PageSizeMax100,
  PageToken,
  AcceptLanguage
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListAcceptedPortfolioSharesRequest(
    acceptLanguage: Optional[AcceptLanguage] = Optional.Absent,
    pageToken: Optional[PageToken] = Optional.Absent,
    pageSize: Optional[PageSizeMax100] = Optional.Absent,
    portfolioShareType: Optional[
      zio.aws.servicecatalog.model.PortfolioShareType
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.ListAcceptedPortfolioSharesRequest = {
    import ListAcceptedPortfolioSharesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.ListAcceptedPortfolioSharesRequest
      .builder()
      .optionallyWith(
        acceptLanguage.map(value =>
          AcceptLanguage.unwrap(value): java.lang.String
        )
      )(_.acceptLanguage)
      .optionallyWith(
        pageToken.map(value => PageToken.unwrap(value): java.lang.String)
      )(_.pageToken)
      .optionallyWith(
        pageSize.map(value => PageSizeMax100.unwrap(value): Integer)
      )(_.pageSize)
      .optionallyWith(portfolioShareType.map(value => value.unwrap))(
        _.portfolioShareType
      )
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.ListAcceptedPortfolioSharesRequest.ReadOnly =
    zio.aws.servicecatalog.model.ListAcceptedPortfolioSharesRequest
      .wrap(buildAwsValue())
}
object ListAcceptedPortfolioSharesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.ListAcceptedPortfolioSharesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.servicecatalog.model.ListAcceptedPortfolioSharesRequest =
      zio.aws.servicecatalog.model.ListAcceptedPortfolioSharesRequest(
        acceptLanguage.map(value => value),
        pageToken.map(value => value),
        pageSize.map(value => value),
        portfolioShareType.map(value => value)
      )
    def acceptLanguage: Optional[AcceptLanguage]
    def pageToken: Optional[PageToken]
    def pageSize: Optional[PageSizeMax100]
    def portfolioShareType
        : Optional[zio.aws.servicecatalog.model.PortfolioShareType]
    def getAcceptLanguage: ZIO[Any, AwsError, AcceptLanguage] =
      AwsError.unwrapOptionField("acceptLanguage", acceptLanguage)
    def getPageToken: ZIO[Any, AwsError, PageToken] =
      AwsError.unwrapOptionField("pageToken", pageToken)
    def getPageSize: ZIO[Any, AwsError, PageSizeMax100] =
      AwsError.unwrapOptionField("pageSize", pageSize)
    def getPortfolioShareType
        : ZIO[Any, AwsError, zio.aws.servicecatalog.model.PortfolioShareType] =
      AwsError.unwrapOptionField("portfolioShareType", portfolioShareType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.ListAcceptedPortfolioSharesRequest
  ) extends zio.aws.servicecatalog.model.ListAcceptedPortfolioSharesRequest.ReadOnly {
    override val acceptLanguage: Optional[AcceptLanguage] =
      zio.aws.core.internal
        .optionalFromNullable(impl.acceptLanguage())
        .map(value =>
          zio.aws.servicecatalog.model.primitives.AcceptLanguage(value)
        )
    override val pageToken: Optional[PageToken] = zio.aws.core.internal
      .optionalFromNullable(impl.pageToken())
      .map(value => zio.aws.servicecatalog.model.primitives.PageToken(value))
    override val pageSize: Optional[PageSizeMax100] = zio.aws.core.internal
      .optionalFromNullable(impl.pageSize())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.PageSizeMax100(value)
      )
    override val portfolioShareType
        : Optional[zio.aws.servicecatalog.model.PortfolioShareType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.portfolioShareType())
        .map(value =>
          zio.aws.servicecatalog.model.PortfolioShareType.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.ListAcceptedPortfolioSharesRequest
  ): zio.aws.servicecatalog.model.ListAcceptedPortfolioSharesRequest.ReadOnly =
    new Wrapper(impl)
}
