package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.servicecatalog.model.primitives.{
  IdempotencyToken,
  Id,
  AcceptLanguage
}
import scala.jdk.CollectionConverters._
final case class ExecuteProvisionedProductPlanRequest(
    acceptLanguage: Optional[AcceptLanguage] = Optional.Absent,
    planId: Id,
    idempotencyToken: IdempotencyToken
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.ExecuteProvisionedProductPlanRequest = {
    import ExecuteProvisionedProductPlanRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.ExecuteProvisionedProductPlanRequest
      .builder()
      .optionallyWith(
        acceptLanguage.map(value =>
          AcceptLanguage.unwrap(value): java.lang.String
        )
      )(_.acceptLanguage)
      .planId(Id.unwrap(planId): java.lang.String)
      .idempotencyToken(
        IdempotencyToken.unwrap(idempotencyToken): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.ExecuteProvisionedProductPlanRequest.ReadOnly =
    zio.aws.servicecatalog.model.ExecuteProvisionedProductPlanRequest
      .wrap(buildAwsValue())
}
object ExecuteProvisionedProductPlanRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.ExecuteProvisionedProductPlanRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.servicecatalog.model.ExecuteProvisionedProductPlanRequest =
      zio.aws.servicecatalog.model.ExecuteProvisionedProductPlanRequest(
        acceptLanguage.map(value => value),
        planId,
        idempotencyToken
      )
    def acceptLanguage: Optional[AcceptLanguage]
    def planId: Id
    def idempotencyToken: IdempotencyToken
    def getAcceptLanguage: ZIO[Any, AwsError, AcceptLanguage] =
      AwsError.unwrapOptionField("acceptLanguage", acceptLanguage)
    def getPlanId: ZIO[Any, Nothing, Id] = ZIO.succeed(planId)
    def getIdempotencyToken: ZIO[Any, Nothing, IdempotencyToken] =
      ZIO.succeed(idempotencyToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.ExecuteProvisionedProductPlanRequest
  ) extends zio.aws.servicecatalog.model.ExecuteProvisionedProductPlanRequest.ReadOnly {
    override val acceptLanguage: Optional[AcceptLanguage] =
      zio.aws.core.internal
        .optionalFromNullable(impl.acceptLanguage())
        .map(value =>
          zio.aws.servicecatalog.model.primitives.AcceptLanguage(value)
        )
    override val planId: Id =
      zio.aws.servicecatalog.model.primitives.Id(impl.planId())
    override val idempotencyToken: IdempotencyToken =
      zio.aws.servicecatalog.model.primitives
        .IdempotencyToken(impl.idempotencyToken())
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.ExecuteProvisionedProductPlanRequest
  ): zio.aws.servicecatalog.model.ExecuteProvisionedProductPlanRequest.ReadOnly =
    new Wrapper(impl)
}
