package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.servicecatalog.model.primitives.{
  ProductViewName,
  Id,
  AcceptLanguage
}
import scala.jdk.CollectionConverters._
final case class DescribeProductAsAdminRequest(
    acceptLanguage: Optional[AcceptLanguage] = Optional.Absent,
    id: Optional[Id] = Optional.Absent,
    name: Optional[ProductViewName] = Optional.Absent,
    sourcePortfolioId: Optional[Id] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.DescribeProductAsAdminRequest = {
    import DescribeProductAsAdminRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.DescribeProductAsAdminRequest
      .builder()
      .optionallyWith(
        acceptLanguage.map(value =>
          AcceptLanguage.unwrap(value): java.lang.String
        )
      )(_.acceptLanguage)
      .optionallyWith(id.map(value => Id.unwrap(value): java.lang.String))(_.id)
      .optionallyWith(
        name.map(value => ProductViewName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        sourcePortfolioId.map(value => Id.unwrap(value): java.lang.String)
      )(_.sourcePortfolioId)
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.DescribeProductAsAdminRequest.ReadOnly =
    zio.aws.servicecatalog.model.DescribeProductAsAdminRequest
      .wrap(buildAwsValue())
}
object DescribeProductAsAdminRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.DescribeProductAsAdminRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicecatalog.model.DescribeProductAsAdminRequest =
      zio.aws.servicecatalog.model.DescribeProductAsAdminRequest(
        acceptLanguage.map(value => value),
        id.map(value => value),
        name.map(value => value),
        sourcePortfolioId.map(value => value)
      )
    def acceptLanguage: Optional[AcceptLanguage]
    def id: Optional[Id]
    def name: Optional[ProductViewName]
    def sourcePortfolioId: Optional[Id]
    def getAcceptLanguage: ZIO[Any, AwsError, AcceptLanguage] =
      AwsError.unwrapOptionField("acceptLanguage", acceptLanguage)
    def getId: ZIO[Any, AwsError, Id] = AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, AwsError, ProductViewName] =
      AwsError.unwrapOptionField("name", name)
    def getSourcePortfolioId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("sourcePortfolioId", sourcePortfolioId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.DescribeProductAsAdminRequest
  ) extends zio.aws.servicecatalog.model.DescribeProductAsAdminRequest.ReadOnly {
    override val acceptLanguage: Optional[AcceptLanguage] =
      zio.aws.core.internal
        .optionalFromNullable(impl.acceptLanguage())
        .map(value =>
          zio.aws.servicecatalog.model.primitives.AcceptLanguage(value)
        )
    override val id: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.servicecatalog.model.primitives.Id(value))
    override val name: Optional[ProductViewName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.ProductViewName(value)
      )
    override val sourcePortfolioId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.sourcePortfolioId())
      .map(value => zio.aws.servicecatalog.model.primitives.Id(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.DescribeProductAsAdminRequest
  ): zio.aws.servicecatalog.model.DescribeProductAsAdminRequest.ReadOnly =
    new Wrapper(impl)
}
