package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.servicecatalog.model.primitives.{
  AcceptLanguage,
  ProviderName,
  IdempotencyToken,
  PortfolioDisplayName,
  PortfolioDescription
}
import scala.jdk.CollectionConverters._
final case class CreatePortfolioRequest(
    acceptLanguage: Optional[AcceptLanguage] = Optional.Absent,
    displayName: PortfolioDisplayName,
    description: Optional[PortfolioDescription] = Optional.Absent,
    providerName: ProviderName,
    tags: Optional[Iterable[zio.aws.servicecatalog.model.Tag]] =
      Optional.Absent,
    idempotencyToken: IdempotencyToken
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.CreatePortfolioRequest = {
    import CreatePortfolioRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.CreatePortfolioRequest
      .builder()
      .optionallyWith(
        acceptLanguage.map(value =>
          AcceptLanguage.unwrap(value): java.lang.String
        )
      )(_.acceptLanguage)
      .displayName(PortfolioDisplayName.unwrap(displayName): java.lang.String)
      .optionallyWith(
        description.map(value =>
          PortfolioDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .providerName(ProviderName.unwrap(providerName): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .idempotencyToken(
        IdempotencyToken.unwrap(idempotencyToken): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.servicecatalog.model.CreatePortfolioRequest.ReadOnly =
    zio.aws.servicecatalog.model.CreatePortfolioRequest.wrap(buildAwsValue())
}
object CreatePortfolioRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.CreatePortfolioRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicecatalog.model.CreatePortfolioRequest =
      zio.aws.servicecatalog.model.CreatePortfolioRequest(
        acceptLanguage.map(value => value),
        displayName,
        description.map(value => value),
        providerName,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        idempotencyToken
      )
    def acceptLanguage: Optional[AcceptLanguage]
    def displayName: PortfolioDisplayName
    def description: Optional[PortfolioDescription]
    def providerName: ProviderName
    def tags: Optional[List[zio.aws.servicecatalog.model.Tag.ReadOnly]]
    def idempotencyToken: IdempotencyToken
    def getAcceptLanguage: ZIO[Any, AwsError, AcceptLanguage] =
      AwsError.unwrapOptionField("acceptLanguage", acceptLanguage)
    def getDisplayName: ZIO[Any, Nothing, PortfolioDisplayName] =
      ZIO.succeed(displayName)
    def getDescription: ZIO[Any, AwsError, PortfolioDescription] =
      AwsError.unwrapOptionField("description", description)
    def getProviderName: ZIO[Any, Nothing, ProviderName] =
      ZIO.succeed(providerName)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.servicecatalog.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getIdempotencyToken: ZIO[Any, Nothing, IdempotencyToken] =
      ZIO.succeed(idempotencyToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.CreatePortfolioRequest
  ) extends zio.aws.servicecatalog.model.CreatePortfolioRequest.ReadOnly {
    override val acceptLanguage: Optional[AcceptLanguage] =
      zio.aws.core.internal
        .optionalFromNullable(impl.acceptLanguage())
        .map(value =>
          zio.aws.servicecatalog.model.primitives.AcceptLanguage(value)
        )
    override val displayName: PortfolioDisplayName =
      zio.aws.servicecatalog.model.primitives
        .PortfolioDisplayName(impl.displayName())
    override val description: Optional[PortfolioDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.servicecatalog.model.primitives.PortfolioDescription(value)
        )
    override val providerName: ProviderName =
      zio.aws.servicecatalog.model.primitives.ProviderName(impl.providerName())
    override val tags
        : Optional[List[zio.aws.servicecatalog.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.servicecatalog.model.Tag.wrap(item)
          }.toList
        )
    override val idempotencyToken: IdempotencyToken =
      zio.aws.servicecatalog.model.primitives
        .IdempotencyToken(impl.idempotencyToken())
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.CreatePortfolioRequest
  ): zio.aws.servicecatalog.model.CreatePortfolioRequest.ReadOnly = new Wrapper(
    impl
  )
}
