package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.servicecatalog.model.primitives.AccessLevelFilterValue
import scala.jdk.CollectionConverters._
final case class AccessLevelFilter(
    key: Optional[zio.aws.servicecatalog.model.AccessLevelFilterKey] =
      Optional.Absent,
    value: Optional[AccessLevelFilterValue] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.AccessLevelFilter = {
    import AccessLevelFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.AccessLevelFilter
      .builder()
      .optionallyWith(key.map(value => value.unwrap))(_.key)
      .optionallyWith(
        value.map(value =>
          AccessLevelFilterValue.unwrap(value): java.lang.String
        )
      )(_.value)
      .build()
  }
  def asReadOnly: zio.aws.servicecatalog.model.AccessLevelFilter.ReadOnly =
    zio.aws.servicecatalog.model.AccessLevelFilter.wrap(buildAwsValue())
}
object AccessLevelFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.AccessLevelFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicecatalog.model.AccessLevelFilter =
      zio.aws.servicecatalog.model
        .AccessLevelFilter(key.map(value => value), value.map(value => value))
    def key: Optional[zio.aws.servicecatalog.model.AccessLevelFilterKey]
    def value: Optional[AccessLevelFilterValue]
    def getKey: ZIO[
      Any,
      AwsError,
      zio.aws.servicecatalog.model.AccessLevelFilterKey
    ] = AwsError.unwrapOptionField("key", key)
    def getValue: ZIO[Any, AwsError, AccessLevelFilterValue] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.AccessLevelFilter
  ) extends zio.aws.servicecatalog.model.AccessLevelFilter.ReadOnly {
    override val key
        : Optional[zio.aws.servicecatalog.model.AccessLevelFilterKey] =
      zio.aws.core.internal
        .optionalFromNullable(impl.key())
        .map(value =>
          zio.aws.servicecatalog.model.AccessLevelFilterKey.wrap(value)
        )
    override val value: Optional[AccessLevelFilterValue] = zio.aws.core.internal
      .optionalFromNullable(impl.value())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.AccessLevelFilterValue(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.AccessLevelFilter
  ): zio.aws.servicecatalog.model.AccessLevelFilter.ReadOnly = new Wrapper(impl)
}
