package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.servicecatalog.model.primitives.{
  AcceptLanguage,
  ProvisioningArtifactName,
  ProvisioningArtifactActive,
  ProvisioningArtifactDescription,
  Id
}
import scala.jdk.CollectionConverters._
final case class UpdateProvisioningArtifactRequest(
    acceptLanguage: Optional[AcceptLanguage] = Optional.Absent,
    productId: Id,
    provisioningArtifactId: Id,
    name: Optional[ProvisioningArtifactName] = Optional.Absent,
    description: Optional[ProvisioningArtifactDescription] = Optional.Absent,
    active: Optional[ProvisioningArtifactActive] = Optional.Absent,
    guidance: Optional[
      zio.aws.servicecatalog.model.ProvisioningArtifactGuidance
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.UpdateProvisioningArtifactRequest = {
    import UpdateProvisioningArtifactRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.UpdateProvisioningArtifactRequest
      .builder()
      .optionallyWith(
        acceptLanguage.map(value =>
          AcceptLanguage.unwrap(value): java.lang.String
        )
      )(_.acceptLanguage)
      .productId(Id.unwrap(productId): java.lang.String)
      .provisioningArtifactId(
        Id.unwrap(provisioningArtifactId): java.lang.String
      )
      .optionallyWith(
        name.map(value =>
          ProvisioningArtifactName.unwrap(value): java.lang.String
        )
      )(_.name)
      .optionallyWith(
        description.map(value =>
          ProvisioningArtifactDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        active.map(value =>
          ProvisioningArtifactActive.unwrap(value): java.lang.Boolean
        )
      )(_.active)
      .optionallyWith(guidance.map(value => value.unwrap))(_.guidance)
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.UpdateProvisioningArtifactRequest.ReadOnly =
    zio.aws.servicecatalog.model.UpdateProvisioningArtifactRequest
      .wrap(buildAwsValue())
}
object UpdateProvisioningArtifactRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.UpdateProvisioningArtifactRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.servicecatalog.model.UpdateProvisioningArtifactRequest =
      zio.aws.servicecatalog.model.UpdateProvisioningArtifactRequest(
        acceptLanguage.map(value => value),
        productId,
        provisioningArtifactId,
        name.map(value => value),
        description.map(value => value),
        active.map(value => value),
        guidance.map(value => value)
      )
    def acceptLanguage: Optional[AcceptLanguage]
    def productId: Id
    def provisioningArtifactId: Id
    def name: Optional[ProvisioningArtifactName]
    def description: Optional[ProvisioningArtifactDescription]
    def active: Optional[ProvisioningArtifactActive]
    def guidance
        : Optional[zio.aws.servicecatalog.model.ProvisioningArtifactGuidance]
    def getAcceptLanguage: ZIO[Any, AwsError, AcceptLanguage] =
      AwsError.unwrapOptionField("acceptLanguage", acceptLanguage)
    def getProductId: ZIO[Any, Nothing, Id] = ZIO.succeed(productId)
    def getProvisioningArtifactId: ZIO[Any, Nothing, Id] =
      ZIO.succeed(provisioningArtifactId)
    def getName: ZIO[Any, AwsError, ProvisioningArtifactName] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, ProvisioningArtifactDescription] =
      AwsError.unwrapOptionField("description", description)
    def getActive: ZIO[Any, AwsError, ProvisioningArtifactActive] =
      AwsError.unwrapOptionField("active", active)
    def getGuidance: ZIO[
      Any,
      AwsError,
      zio.aws.servicecatalog.model.ProvisioningArtifactGuidance
    ] = AwsError.unwrapOptionField("guidance", guidance)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.UpdateProvisioningArtifactRequest
  ) extends zio.aws.servicecatalog.model.UpdateProvisioningArtifactRequest.ReadOnly {
    override val acceptLanguage: Optional[AcceptLanguage] =
      zio.aws.core.internal
        .optionalFromNullable(impl.acceptLanguage())
        .map(value =>
          zio.aws.servicecatalog.model.primitives.AcceptLanguage(value)
        )
    override val productId: Id =
      zio.aws.servicecatalog.model.primitives.Id(impl.productId())
    override val provisioningArtifactId: Id =
      zio.aws.servicecatalog.model.primitives.Id(impl.provisioningArtifactId())
    override val name: Optional[ProvisioningArtifactName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.name())
        .map(value =>
          zio.aws.servicecatalog.model.primitives
            .ProvisioningArtifactName(value)
        )
    override val description: Optional[ProvisioningArtifactDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.servicecatalog.model.primitives
            .ProvisioningArtifactDescription(value)
        )
    override val active: Optional[ProvisioningArtifactActive] =
      zio.aws.core.internal
        .optionalFromNullable(impl.active())
        .map(value =>
          zio.aws.servicecatalog.model.primitives
            .ProvisioningArtifactActive(value)
        )
    override val guidance
        : Optional[zio.aws.servicecatalog.model.ProvisioningArtifactGuidance] =
      zio.aws.core.internal
        .optionalFromNullable(impl.guidance())
        .map(value =>
          zio.aws.servicecatalog.model.ProvisioningArtifactGuidance.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.UpdateProvisioningArtifactRequest
  ): zio.aws.servicecatalog.model.UpdateProvisioningArtifactRequest.ReadOnly =
    new Wrapper(impl)
}
