package zio.aws.servicecatalog.model
import zio.aws.servicecatalog.model.primitives.{
  AcceptLanguage,
  SortField,
  SearchProvisionedProductsPageSize,
  PageToken,
  ProvisionedProductViewFilterValue
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class SearchProvisionedProductsRequest(
    acceptLanguage: Optional[AcceptLanguage] = Optional.Absent,
    accessLevelFilter: Optional[
      zio.aws.servicecatalog.model.AccessLevelFilter
    ] = Optional.Absent,
    filters: Optional[
      Map[zio.aws.servicecatalog.model.ProvisionedProductViewFilterBy, Iterable[
        ProvisionedProductViewFilterValue
      ]]
    ] = Optional.Absent,
    sortBy: Optional[SortField] = Optional.Absent,
    sortOrder: Optional[zio.aws.servicecatalog.model.SortOrder] =
      Optional.Absent,
    pageSize: Optional[SearchProvisionedProductsPageSize] = Optional.Absent,
    pageToken: Optional[PageToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.SearchProvisionedProductsRequest = {
    import SearchProvisionedProductsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.SearchProvisionedProductsRequest
      .builder()
      .optionallyWith(
        acceptLanguage.map(value =>
          AcceptLanguage.unwrap(value): java.lang.String
        )
      )(_.acceptLanguage)
      .optionallyWith(accessLevelFilter.map(value => value.buildAwsValue()))(
        _.accessLevelFilter
      )
      .optionallyWith(
        filters.map(value =>
          value
            .map({ case (key, value) =>
              key.unwrap.toString -> value.map { item =>
                ProvisionedProductViewFilterValue.unwrap(item): java.lang.String
              }.asJavaCollection
            })
            .asJava
        )
      )(_.filtersWithStrings)
      .optionallyWith(
        sortBy.map(value => SortField.unwrap(value): java.lang.String)
      )(_.sortBy)
      .optionallyWith(sortOrder.map(value => value.unwrap))(_.sortOrder)
      .optionallyWith(
        pageSize.map(value =>
          SearchProvisionedProductsPageSize.unwrap(value): Integer
        )
      )(_.pageSize)
      .optionallyWith(
        pageToken.map(value => PageToken.unwrap(value): java.lang.String)
      )(_.pageToken)
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.SearchProvisionedProductsRequest.ReadOnly =
    zio.aws.servicecatalog.model.SearchProvisionedProductsRequest
      .wrap(buildAwsValue())
}
object SearchProvisionedProductsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.SearchProvisionedProductsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.servicecatalog.model.SearchProvisionedProductsRequest =
      zio.aws.servicecatalog.model.SearchProvisionedProductsRequest(
        acceptLanguage.map(value => value),
        accessLevelFilter.map(value => value.asEditable),
        filters.map(value => value),
        sortBy.map(value => value),
        sortOrder.map(value => value),
        pageSize.map(value => value),
        pageToken.map(value => value)
      )
    def acceptLanguage: Optional[AcceptLanguage]
    def accessLevelFilter
        : Optional[zio.aws.servicecatalog.model.AccessLevelFilter.ReadOnly]
    def filters: Optional[
      Map[zio.aws.servicecatalog.model.ProvisionedProductViewFilterBy, List[
        ProvisionedProductViewFilterValue
      ]]
    ]
    def sortBy: Optional[SortField]
    def sortOrder: Optional[zio.aws.servicecatalog.model.SortOrder]
    def pageSize: Optional[SearchProvisionedProductsPageSize]
    def pageToken: Optional[PageToken]
    def getAcceptLanguage: ZIO[Any, AwsError, AcceptLanguage] =
      AwsError.unwrapOptionField("acceptLanguage", acceptLanguage)
    def getAccessLevelFilter: ZIO[
      Any,
      AwsError,
      zio.aws.servicecatalog.model.AccessLevelFilter.ReadOnly
    ] = AwsError.unwrapOptionField("accessLevelFilter", accessLevelFilter)
    def getFilters: ZIO[Any, AwsError, Map[
      zio.aws.servicecatalog.model.ProvisionedProductViewFilterBy,
      List[ProvisionedProductViewFilterValue]
    ]] = AwsError.unwrapOptionField("filters", filters)
    def getSortBy: ZIO[Any, AwsError, SortField] =
      AwsError.unwrapOptionField("sortBy", sortBy)
    def getSortOrder
        : ZIO[Any, AwsError, zio.aws.servicecatalog.model.SortOrder] =
      AwsError.unwrapOptionField("sortOrder", sortOrder)
    def getPageSize: ZIO[Any, AwsError, SearchProvisionedProductsPageSize] =
      AwsError.unwrapOptionField("pageSize", pageSize)
    def getPageToken: ZIO[Any, AwsError, PageToken] =
      AwsError.unwrapOptionField("pageToken", pageToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.SearchProvisionedProductsRequest
  ) extends zio.aws.servicecatalog.model.SearchProvisionedProductsRequest.ReadOnly {
    override val acceptLanguage: Optional[AcceptLanguage] =
      zio.aws.core.internal
        .optionalFromNullable(impl.acceptLanguage())
        .map(value =>
          zio.aws.servicecatalog.model.primitives.AcceptLanguage(value)
        )
    override val accessLevelFilter
        : Optional[zio.aws.servicecatalog.model.AccessLevelFilter.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.accessLevelFilter())
        .map(value =>
          zio.aws.servicecatalog.model.AccessLevelFilter.wrap(value)
        )
    override val filters: Optional[
      Map[zio.aws.servicecatalog.model.ProvisionedProductViewFilterBy, List[
        ProvisionedProductViewFilterValue
      ]]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.filters())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.servicecatalog.model.ProvisionedProductViewFilterBy
              .wrap(key) -> value.asScala.map { item =>
              zio.aws.servicecatalog.model.primitives
                .ProvisionedProductViewFilterValue(item)
            }.toList
          })
          .toMap
      )
    override val sortBy: Optional[SortField] = zio.aws.core.internal
      .optionalFromNullable(impl.sortBy())
      .map(value => zio.aws.servicecatalog.model.primitives.SortField(value))
    override val sortOrder: Optional[zio.aws.servicecatalog.model.SortOrder] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortOrder())
        .map(value => zio.aws.servicecatalog.model.SortOrder.wrap(value))
    override val pageSize: Optional[SearchProvisionedProductsPageSize] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pageSize())
        .map(value =>
          zio.aws.servicecatalog.model.primitives
            .SearchProvisionedProductsPageSize(value)
        )
    override val pageToken: Optional[PageToken] = zio.aws.core.internal
      .optionalFromNullable(impl.pageToken())
      .map(value => zio.aws.servicecatalog.model.primitives.PageToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.SearchProvisionedProductsRequest
  ): zio.aws.servicecatalog.model.SearchProvisionedProductsRequest.ReadOnly =
    new Wrapper(impl)
}
