package zio.aws.servicecatalog.model
import zio.aws.servicecatalog.model.primitives.{
  PageSizeMax100,
  PageToken,
  Id,
  AcceptLanguage
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListPortfoliosForProductRequest(
    acceptLanguage: Optional[AcceptLanguage] = Optional.Absent,
    productId: Id,
    pageToken: Optional[PageToken] = Optional.Absent,
    pageSize: Optional[PageSizeMax100] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.ListPortfoliosForProductRequest = {
    import ListPortfoliosForProductRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.ListPortfoliosForProductRequest
      .builder()
      .optionallyWith(
        acceptLanguage.map(value =>
          AcceptLanguage.unwrap(value): java.lang.String
        )
      )(_.acceptLanguage)
      .productId(Id.unwrap(productId): java.lang.String)
      .optionallyWith(
        pageToken.map(value => PageToken.unwrap(value): java.lang.String)
      )(_.pageToken)
      .optionallyWith(
        pageSize.map(value => PageSizeMax100.unwrap(value): Integer)
      )(_.pageSize)
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.ListPortfoliosForProductRequest.ReadOnly =
    zio.aws.servicecatalog.model.ListPortfoliosForProductRequest
      .wrap(buildAwsValue())
}
object ListPortfoliosForProductRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.ListPortfoliosForProductRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.servicecatalog.model.ListPortfoliosForProductRequest =
      zio.aws.servicecatalog.model.ListPortfoliosForProductRequest(
        acceptLanguage.map(value => value),
        productId,
        pageToken.map(value => value),
        pageSize.map(value => value)
      )
    def acceptLanguage: Optional[AcceptLanguage]
    def productId: Id
    def pageToken: Optional[PageToken]
    def pageSize: Optional[PageSizeMax100]
    def getAcceptLanguage: ZIO[Any, AwsError, AcceptLanguage] =
      AwsError.unwrapOptionField("acceptLanguage", acceptLanguage)
    def getProductId: ZIO[Any, Nothing, Id] = ZIO.succeed(productId)
    def getPageToken: ZIO[Any, AwsError, PageToken] =
      AwsError.unwrapOptionField("pageToken", pageToken)
    def getPageSize: ZIO[Any, AwsError, PageSizeMax100] =
      AwsError.unwrapOptionField("pageSize", pageSize)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.ListPortfoliosForProductRequest
  ) extends zio.aws.servicecatalog.model.ListPortfoliosForProductRequest.ReadOnly {
    override val acceptLanguage: Optional[AcceptLanguage] =
      zio.aws.core.internal
        .optionalFromNullable(impl.acceptLanguage())
        .map(value =>
          zio.aws.servicecatalog.model.primitives.AcceptLanguage(value)
        )
    override val productId: Id =
      zio.aws.servicecatalog.model.primitives.Id(impl.productId())
    override val pageToken: Optional[PageToken] = zio.aws.core.internal
      .optionalFromNullable(impl.pageToken())
      .map(value => zio.aws.servicecatalog.model.primitives.PageToken(value))
    override val pageSize: Optional[PageSizeMax100] = zio.aws.core.internal
      .optionalFromNullable(impl.pageSize())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.PageSizeMax100(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.ListPortfoliosForProductRequest
  ): zio.aws.servicecatalog.model.ListPortfoliosForProductRequest.ReadOnly =
    new Wrapper(impl)
}
