package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.servicecatalog.model.primitives.{PortfolioName, Id}
import scala.jdk.CollectionConverters._
final case class LaunchPathSummary(
    id: Optional[Id] = Optional.Absent,
    constraintSummaries: Optional[
      Iterable[zio.aws.servicecatalog.model.ConstraintSummary]
    ] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.servicecatalog.model.Tag]] =
      Optional.Absent,
    name: Optional[PortfolioName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.LaunchPathSummary = {
    import LaunchPathSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.LaunchPathSummary
      .builder()
      .optionallyWith(id.map(value => Id.unwrap(value): java.lang.String))(_.id)
      .optionallyWith(
        constraintSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.constraintSummaries)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        name.map(value => PortfolioName.unwrap(value): java.lang.String)
      )(_.name)
      .build()
  }
  def asReadOnly: zio.aws.servicecatalog.model.LaunchPathSummary.ReadOnly =
    zio.aws.servicecatalog.model.LaunchPathSummary.wrap(buildAwsValue())
}
object LaunchPathSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.LaunchPathSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicecatalog.model.LaunchPathSummary =
      zio.aws.servicecatalog.model.LaunchPathSummary(
        id.map(value => value),
        constraintSummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        name.map(value => value)
      )
    def id: Optional[Id]
    def constraintSummaries: Optional[
      List[zio.aws.servicecatalog.model.ConstraintSummary.ReadOnly]
    ]
    def tags: Optional[List[zio.aws.servicecatalog.model.Tag.ReadOnly]]
    def name: Optional[PortfolioName]
    def getId: ZIO[Any, AwsError, Id] = AwsError.unwrapOptionField("id", id)
    def getConstraintSummaries: ZIO[Any, AwsError, List[
      zio.aws.servicecatalog.model.ConstraintSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("constraintSummaries", constraintSummaries)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.servicecatalog.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getName: ZIO[Any, AwsError, PortfolioName] =
      AwsError.unwrapOptionField("name", name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.LaunchPathSummary
  ) extends zio.aws.servicecatalog.model.LaunchPathSummary.ReadOnly {
    override val id: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.servicecatalog.model.primitives.Id(value))
    override val constraintSummaries: Optional[
      List[zio.aws.servicecatalog.model.ConstraintSummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.constraintSummaries())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.servicecatalog.model.ConstraintSummary.wrap(item)
        }.toList
      )
    override val tags
        : Optional[List[zio.aws.servicecatalog.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.servicecatalog.model.Tag.wrap(item)
          }.toList
        )
    override val name: Optional[PortfolioName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.PortfolioName(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.LaunchPathSummary
  ): zio.aws.servicecatalog.model.LaunchPathSummary.ReadOnly = new Wrapper(impl)
}
