package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.servicecatalog.model.primitives.{
  InstructionValue,
  InstructionType
}
import scala.jdk.CollectionConverters._
final case class UsageInstruction(
    `type`: Optional[InstructionType] = Optional.Absent,
    value: Optional[InstructionValue] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.UsageInstruction = {
    import UsageInstruction.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.UsageInstruction
      .builder()
      .optionallyWith(
        `type`.map(value => InstructionType.unwrap(value): java.lang.String)
      )(_.`type`)
      .optionallyWith(
        value.map(value => InstructionValue.unwrap(value): java.lang.String)
      )(_.value)
      .build()
  }
  def asReadOnly: zio.aws.servicecatalog.model.UsageInstruction.ReadOnly =
    zio.aws.servicecatalog.model.UsageInstruction.wrap(buildAwsValue())
}
object UsageInstruction {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.UsageInstruction
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicecatalog.model.UsageInstruction =
      zio.aws.servicecatalog.model
        .UsageInstruction(`type`.map(value => value), value.map(value => value))
    def `type`: Optional[InstructionType]
    def value: Optional[InstructionValue]
    def getType: ZIO[Any, AwsError, InstructionType] =
      AwsError.unwrapOptionField("type", `type`)
    def getValue: ZIO[Any, AwsError, InstructionValue] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.UsageInstruction
  ) extends zio.aws.servicecatalog.model.UsageInstruction.ReadOnly {
    override val `type`: Optional[InstructionType] = zio.aws.core.internal
      .optionalFromNullable(impl.`type`())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.InstructionType(value)
      )
    override val value: Optional[InstructionValue] = zio.aws.core.internal
      .optionalFromNullable(impl.value())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.InstructionValue(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.UsageInstruction
  ): zio.aws.servicecatalog.model.UsageInstruction.ReadOnly = new Wrapper(impl)
}
