package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.servicecatalog.model.primitives.{
  UsePreviousValue,
  ParameterValue,
  ParameterKey
}
import scala.jdk.CollectionConverters._
final case class UpdateProvisioningParameter(
    key: Optional[ParameterKey] = Optional.Absent,
    value: Optional[ParameterValue] = Optional.Absent,
    usePreviousValue: Optional[UsePreviousValue] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.UpdateProvisioningParameter = {
    import UpdateProvisioningParameter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.UpdateProvisioningParameter
      .builder()
      .optionallyWith(
        key.map(value => ParameterKey.unwrap(value): java.lang.String)
      )(_.key)
      .optionallyWith(
        value.map(value => ParameterValue.unwrap(value): java.lang.String)
      )(_.value)
      .optionallyWith(
        usePreviousValue.map(value =>
          UsePreviousValue.unwrap(value): java.lang.Boolean
        )
      )(_.usePreviousValue)
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.UpdateProvisioningParameter.ReadOnly =
    zio.aws.servicecatalog.model.UpdateProvisioningParameter
      .wrap(buildAwsValue())
}
object UpdateProvisioningParameter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.UpdateProvisioningParameter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicecatalog.model.UpdateProvisioningParameter =
      zio.aws.servicecatalog.model.UpdateProvisioningParameter(
        key.map(value => value),
        value.map(value => value),
        usePreviousValue.map(value => value)
      )
    def key: Optional[ParameterKey]
    def value: Optional[ParameterValue]
    def usePreviousValue: Optional[UsePreviousValue]
    def getKey: ZIO[Any, AwsError, ParameterKey] =
      AwsError.unwrapOptionField("key", key)
    def getValue: ZIO[Any, AwsError, ParameterValue] =
      AwsError.unwrapOptionField("value", value)
    def getUsePreviousValue: ZIO[Any, AwsError, UsePreviousValue] =
      AwsError.unwrapOptionField("usePreviousValue", usePreviousValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.UpdateProvisioningParameter
  ) extends zio.aws.servicecatalog.model.UpdateProvisioningParameter.ReadOnly {
    override val key: Optional[ParameterKey] = zio.aws.core.internal
      .optionalFromNullable(impl.key())
      .map(value => zio.aws.servicecatalog.model.primitives.ParameterKey(value))
    override val value: Optional[ParameterValue] = zio.aws.core.internal
      .optionalFromNullable(impl.value())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.ParameterValue(value)
      )
    override val usePreviousValue: Optional[UsePreviousValue] =
      zio.aws.core.internal
        .optionalFromNullable(impl.usePreviousValue())
        .map(value =>
          zio.aws.servicecatalog.model.primitives.UsePreviousValue(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.UpdateProvisioningParameter
  ): zio.aws.servicecatalog.model.UpdateProvisioningParameter.ReadOnly =
    new Wrapper(impl)
}
