package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.servicecatalog.model.primitives.Id
import scala.jdk.CollectionConverters._
final case class DescribePortfolioShareStatusRequest(portfolioShareToken: Id) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.DescribePortfolioShareStatusRequest = {
    import DescribePortfolioShareStatusRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.DescribePortfolioShareStatusRequest
      .builder()
      .portfolioShareToken(Id.unwrap(portfolioShareToken): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.DescribePortfolioShareStatusRequest.ReadOnly =
    zio.aws.servicecatalog.model.DescribePortfolioShareStatusRequest
      .wrap(buildAwsValue())
}
object DescribePortfolioShareStatusRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.DescribePortfolioShareStatusRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.servicecatalog.model.DescribePortfolioShareStatusRequest =
      zio.aws.servicecatalog.model
        .DescribePortfolioShareStatusRequest(portfolioShareToken)
    def portfolioShareToken: Id
    def getPortfolioShareToken: ZIO[Any, Nothing, Id] =
      ZIO.succeed(portfolioShareToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.DescribePortfolioShareStatusRequest
  ) extends zio.aws.servicecatalog.model.DescribePortfolioShareStatusRequest.ReadOnly {
    override val portfolioShareToken: Id =
      zio.aws.servicecatalog.model.primitives.Id(impl.portfolioShareToken())
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.DescribePortfolioShareStatusRequest
  ): zio.aws.servicecatalog.model.DescribePortfolioShareStatusRequest.ReadOnly =
    new Wrapper(impl)
}
