package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.servicecatalog.model.primitives.{Id, AcceptLanguage}
import scala.jdk.CollectionConverters._
final case class DeletePortfolioRequest(
    acceptLanguage: Optional[AcceptLanguage] = Optional.Absent,
    id: Id
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.DeletePortfolioRequest = {
    import DeletePortfolioRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.DeletePortfolioRequest
      .builder()
      .optionallyWith(
        acceptLanguage.map(value =>
          AcceptLanguage.unwrap(value): java.lang.String
        )
      )(_.acceptLanguage)
      .id(Id.unwrap(id): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.servicecatalog.model.DeletePortfolioRequest.ReadOnly =
    zio.aws.servicecatalog.model.DeletePortfolioRequest.wrap(buildAwsValue())
}
object DeletePortfolioRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.DeletePortfolioRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicecatalog.model.DeletePortfolioRequest =
      zio.aws.servicecatalog.model
        .DeletePortfolioRequest(acceptLanguage.map(value => value), id)
    def acceptLanguage: Optional[AcceptLanguage]
    def id: Id
    def getAcceptLanguage: ZIO[Any, AwsError, AcceptLanguage] =
      AwsError.unwrapOptionField("acceptLanguage", acceptLanguage)
    def getId: ZIO[Any, Nothing, Id] = ZIO.succeed(id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.DeletePortfolioRequest
  ) extends zio.aws.servicecatalog.model.DeletePortfolioRequest.ReadOnly {
    override val acceptLanguage: Optional[AcceptLanguage] =
      zio.aws.core.internal
        .optionalFromNullable(impl.acceptLanguage())
        .map(value =>
          zio.aws.servicecatalog.model.primitives.AcceptLanguage(value)
        )
    override val id: Id = zio.aws.servicecatalog.model.primitives.Id(impl.id())
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.DeletePortfolioRequest
  ): zio.aws.servicecatalog.model.DeletePortfolioRequest.ReadOnly = new Wrapper(
    impl
  )
}
