package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.servicecatalog.model.primitives.{Id, AcceptLanguage}
import scala.jdk.CollectionConverters._
final case class AssociateProductWithPortfolioRequest(
    acceptLanguage: Optional[AcceptLanguage] = Optional.Absent,
    productId: Id,
    portfolioId: Id,
    sourcePortfolioId: Optional[Id] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.AssociateProductWithPortfolioRequest = {
    import AssociateProductWithPortfolioRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.AssociateProductWithPortfolioRequest
      .builder()
      .optionallyWith(
        acceptLanguage.map(value =>
          AcceptLanguage.unwrap(value): java.lang.String
        )
      )(_.acceptLanguage)
      .productId(Id.unwrap(productId): java.lang.String)
      .portfolioId(Id.unwrap(portfolioId): java.lang.String)
      .optionallyWith(
        sourcePortfolioId.map(value => Id.unwrap(value): java.lang.String)
      )(_.sourcePortfolioId)
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.AssociateProductWithPortfolioRequest.ReadOnly =
    zio.aws.servicecatalog.model.AssociateProductWithPortfolioRequest
      .wrap(buildAwsValue())
}
object AssociateProductWithPortfolioRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.AssociateProductWithPortfolioRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.servicecatalog.model.AssociateProductWithPortfolioRequest =
      zio.aws.servicecatalog.model.AssociateProductWithPortfolioRequest(
        acceptLanguage.map(value => value),
        productId,
        portfolioId,
        sourcePortfolioId.map(value => value)
      )
    def acceptLanguage: Optional[AcceptLanguage]
    def productId: Id
    def portfolioId: Id
    def sourcePortfolioId: Optional[Id]
    def getAcceptLanguage: ZIO[Any, AwsError, AcceptLanguage] =
      AwsError.unwrapOptionField("acceptLanguage", acceptLanguage)
    def getProductId: ZIO[Any, Nothing, Id] = ZIO.succeed(productId)
    def getPortfolioId: ZIO[Any, Nothing, Id] = ZIO.succeed(portfolioId)
    def getSourcePortfolioId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("sourcePortfolioId", sourcePortfolioId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.AssociateProductWithPortfolioRequest
  ) extends zio.aws.servicecatalog.model.AssociateProductWithPortfolioRequest.ReadOnly {
    override val acceptLanguage: Optional[AcceptLanguage] =
      zio.aws.core.internal
        .optionalFromNullable(impl.acceptLanguage())
        .map(value =>
          zio.aws.servicecatalog.model.primitives.AcceptLanguage(value)
        )
    override val productId: Id =
      zio.aws.servicecatalog.model.primitives.Id(impl.productId())
    override val portfolioId: Id =
      zio.aws.servicecatalog.model.primitives.Id(impl.portfolioId())
    override val sourcePortfolioId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.sourcePortfolioId())
      .map(value => zio.aws.servicecatalog.model.primitives.Id(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.AssociateProductWithPortfolioRequest
  ): zio.aws.servicecatalog.model.AssociateProductWithPortfolioRequest.ReadOnly =
    new Wrapper(impl)
}
