package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateServiceActionResponse(
    serviceActionDetail: Optional[
      zio.aws.servicecatalog.model.ServiceActionDetail
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.CreateServiceActionResponse = {
    import CreateServiceActionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.CreateServiceActionResponse
      .builder()
      .optionallyWith(serviceActionDetail.map(value => value.buildAwsValue()))(
        _.serviceActionDetail
      )
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.CreateServiceActionResponse.ReadOnly =
    zio.aws.servicecatalog.model.CreateServiceActionResponse
      .wrap(buildAwsValue())
}
object CreateServiceActionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.CreateServiceActionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicecatalog.model.CreateServiceActionResponse =
      zio.aws.servicecatalog.model.CreateServiceActionResponse(
        serviceActionDetail.map(value => value.asEditable)
      )
    def serviceActionDetail
        : Optional[zio.aws.servicecatalog.model.ServiceActionDetail.ReadOnly]
    def getServiceActionDetail: ZIO[
      Any,
      AwsError,
      zio.aws.servicecatalog.model.ServiceActionDetail.ReadOnly
    ] = AwsError.unwrapOptionField("serviceActionDetail", serviceActionDetail)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.CreateServiceActionResponse
  ) extends zio.aws.servicecatalog.model.CreateServiceActionResponse.ReadOnly {
    override val serviceActionDetail
        : Optional[zio.aws.servicecatalog.model.ServiceActionDetail.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serviceActionDetail())
        .map(value =>
          zio.aws.servicecatalog.model.ServiceActionDetail.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.CreateServiceActionResponse
  ): zio.aws.servicecatalog.model.CreateServiceActionResponse.ReadOnly =
    new Wrapper(impl)
}
