package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.servicecatalog.model.primitives.ConstraintParameters
import scala.jdk.CollectionConverters._
final case class CreateConstraintResponse(
    constraintDetail: Optional[zio.aws.servicecatalog.model.ConstraintDetail] =
      Optional.Absent,
    constraintParameters: Optional[ConstraintParameters] = Optional.Absent,
    status: Optional[zio.aws.servicecatalog.model.Status] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.CreateConstraintResponse = {
    import CreateConstraintResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.CreateConstraintResponse
      .builder()
      .optionallyWith(constraintDetail.map(value => value.buildAwsValue()))(
        _.constraintDetail
      )
      .optionallyWith(
        constraintParameters.map(value =>
          ConstraintParameters.unwrap(value): java.lang.String
        )
      )(_.constraintParameters)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.CreateConstraintResponse.ReadOnly =
    zio.aws.servicecatalog.model.CreateConstraintResponse.wrap(buildAwsValue())
}
object CreateConstraintResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.CreateConstraintResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicecatalog.model.CreateConstraintResponse =
      zio.aws.servicecatalog.model.CreateConstraintResponse(
        constraintDetail.map(value => value.asEditable),
        constraintParameters.map(value => value),
        status.map(value => value)
      )
    def constraintDetail
        : Optional[zio.aws.servicecatalog.model.ConstraintDetail.ReadOnly]
    def constraintParameters: Optional[ConstraintParameters]
    def status: Optional[zio.aws.servicecatalog.model.Status]
    def getConstraintDetail: ZIO[
      Any,
      AwsError,
      zio.aws.servicecatalog.model.ConstraintDetail.ReadOnly
    ] = AwsError.unwrapOptionField("constraintDetail", constraintDetail)
    def getConstraintParameters: ZIO[Any, AwsError, ConstraintParameters] =
      AwsError.unwrapOptionField("constraintParameters", constraintParameters)
    def getStatus: ZIO[Any, AwsError, zio.aws.servicecatalog.model.Status] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.CreateConstraintResponse
  ) extends zio.aws.servicecatalog.model.CreateConstraintResponse.ReadOnly {
    override val constraintDetail
        : Optional[zio.aws.servicecatalog.model.ConstraintDetail.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.constraintDetail())
        .map(value => zio.aws.servicecatalog.model.ConstraintDetail.wrap(value))
    override val constraintParameters: Optional[ConstraintParameters] =
      zio.aws.core.internal
        .optionalFromNullable(impl.constraintParameters())
        .map(value =>
          zio.aws.servicecatalog.model.primitives.ConstraintParameters(value)
        )
    override val status: Optional[zio.aws.servicecatalog.model.Status] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.servicecatalog.model.Status.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.CreateConstraintResponse
  ): zio.aws.servicecatalog.model.CreateConstraintResponse.ReadOnly =
    new Wrapper(impl)
}
