package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.servicecatalog.model.primitives.Id
import scala.jdk.CollectionConverters._
final case class CopyProductResponse(
    copyProductToken: Optional[Id] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.CopyProductResponse = {
    import CopyProductResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.CopyProductResponse
      .builder()
      .optionallyWith(
        copyProductToken.map(value => Id.unwrap(value): java.lang.String)
      )(_.copyProductToken)
      .build()
  }
  def asReadOnly: zio.aws.servicecatalog.model.CopyProductResponse.ReadOnly =
    zio.aws.servicecatalog.model.CopyProductResponse.wrap(buildAwsValue())
}
object CopyProductResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.CopyProductResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicecatalog.model.CopyProductResponse =
      zio.aws.servicecatalog.model
        .CopyProductResponse(copyProductToken.map(value => value))
    def copyProductToken: Optional[Id]
    def getCopyProductToken: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("copyProductToken", copyProductToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.CopyProductResponse
  ) extends zio.aws.servicecatalog.model.CopyProductResponse.ReadOnly {
    override val copyProductToken: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.copyProductToken())
      .map(value => zio.aws.servicecatalog.model.primitives.Id(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.CopyProductResponse
  ): zio.aws.servicecatalog.model.CopyProductResponse.ReadOnly = new Wrapper(
    impl
  )
}
