package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.servicecatalog.model.primitives.{
  AcceptLanguage,
  ProductArn,
  ProvisioningArtifactPropertyValue,
  ProductViewName,
  IdempotencyToken,
  Id
}
import scala.jdk.CollectionConverters._
final case class CopyProductRequest(
    acceptLanguage: Optional[AcceptLanguage] = Optional.Absent,
    sourceProductArn: ProductArn,
    targetProductId: Optional[Id] = Optional.Absent,
    targetProductName: Optional[ProductViewName] = Optional.Absent,
    sourceProvisioningArtifactIdentifiers: Optional[Iterable[Map[
      zio.aws.servicecatalog.model.ProvisioningArtifactPropertyName,
      ProvisioningArtifactPropertyValue
    ]]] = Optional.Absent,
    copyOptions: Optional[Iterable[zio.aws.servicecatalog.model.CopyOption]] =
      Optional.Absent,
    idempotencyToken: IdempotencyToken
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.CopyProductRequest = {
    import CopyProductRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.CopyProductRequest
      .builder()
      .optionallyWith(
        acceptLanguage.map(value =>
          AcceptLanguage.unwrap(value): java.lang.String
        )
      )(_.acceptLanguage)
      .sourceProductArn(ProductArn.unwrap(sourceProductArn): java.lang.String)
      .optionallyWith(
        targetProductId.map(value => Id.unwrap(value): java.lang.String)
      )(_.targetProductId)
      .optionallyWith(
        targetProductName.map(value =>
          ProductViewName.unwrap(value): java.lang.String
        )
      )(_.targetProductName)
      .optionallyWith(
        sourceProvisioningArtifactIdentifiers.map(value =>
          value.map { item =>
            item
              .map({ case (key, value) =>
                key.unwrap.toString -> (ProvisioningArtifactPropertyValue
                  .unwrap(value): java.lang.String)
              })
              .asJava
          }.asJavaCollection
        )
      )(_.sourceProvisioningArtifactIdentifiersWithStrings)
      .optionallyWith(
        copyOptions.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.copyOptionsWithStrings)
      .idempotencyToken(
        IdempotencyToken.unwrap(idempotencyToken): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.servicecatalog.model.CopyProductRequest.ReadOnly =
    zio.aws.servicecatalog.model.CopyProductRequest.wrap(buildAwsValue())
}
object CopyProductRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.CopyProductRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicecatalog.model.CopyProductRequest =
      zio.aws.servicecatalog.model.CopyProductRequest(
        acceptLanguage.map(value => value),
        sourceProductArn,
        targetProductId.map(value => value),
        targetProductName.map(value => value),
        sourceProvisioningArtifactIdentifiers.map(value => value),
        copyOptions.map(value => value),
        idempotencyToken
      )
    def acceptLanguage: Optional[AcceptLanguage]
    def sourceProductArn: ProductArn
    def targetProductId: Optional[Id]
    def targetProductName: Optional[ProductViewName]
    def sourceProvisioningArtifactIdentifiers: Optional[List[Map[
      zio.aws.servicecatalog.model.ProvisioningArtifactPropertyName,
      ProvisioningArtifactPropertyValue
    ]]]
    def copyOptions: Optional[List[zio.aws.servicecatalog.model.CopyOption]]
    def idempotencyToken: IdempotencyToken
    def getAcceptLanguage: ZIO[Any, AwsError, AcceptLanguage] =
      AwsError.unwrapOptionField("acceptLanguage", acceptLanguage)
    def getSourceProductArn: ZIO[Any, Nothing, ProductArn] =
      ZIO.succeed(sourceProductArn)
    def getTargetProductId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("targetProductId", targetProductId)
    def getTargetProductName: ZIO[Any, AwsError, ProductViewName] =
      AwsError.unwrapOptionField("targetProductName", targetProductName)
    def getSourceProvisioningArtifactIdentifiers: ZIO[Any, AwsError, List[Map[
      zio.aws.servicecatalog.model.ProvisioningArtifactPropertyName,
      ProvisioningArtifactPropertyValue
    ]]] = AwsError.unwrapOptionField(
      "sourceProvisioningArtifactIdentifiers",
      sourceProvisioningArtifactIdentifiers
    )
    def getCopyOptions
        : ZIO[Any, AwsError, List[zio.aws.servicecatalog.model.CopyOption]] =
      AwsError.unwrapOptionField("copyOptions", copyOptions)
    def getIdempotencyToken: ZIO[Any, Nothing, IdempotencyToken] =
      ZIO.succeed(idempotencyToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.CopyProductRequest
  ) extends zio.aws.servicecatalog.model.CopyProductRequest.ReadOnly {
    override val acceptLanguage: Optional[AcceptLanguage] =
      zio.aws.core.internal
        .optionalFromNullable(impl.acceptLanguage())
        .map(value =>
          zio.aws.servicecatalog.model.primitives.AcceptLanguage(value)
        )
    override val sourceProductArn: ProductArn =
      zio.aws.servicecatalog.model.primitives
        .ProductArn(impl.sourceProductArn())
    override val targetProductId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.targetProductId())
      .map(value => zio.aws.servicecatalog.model.primitives.Id(value))
    override val targetProductName: Optional[ProductViewName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetProductName())
        .map(value =>
          zio.aws.servicecatalog.model.primitives.ProductViewName(value)
        )
    override val sourceProvisioningArtifactIdentifiers: Optional[List[Map[
      zio.aws.servicecatalog.model.ProvisioningArtifactPropertyName,
      ProvisioningArtifactPropertyValue
    ]]] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceProvisioningArtifactIdentifiers())
      .map(value =>
        value.asScala.map { item =>
          item.asScala
            .map({ case (key, value) =>
              zio.aws.servicecatalog.model.ProvisioningArtifactPropertyName
                .wrap(key) -> zio.aws.servicecatalog.model.primitives
                .ProvisioningArtifactPropertyValue(value)
            })
            .toMap
        }.toList
      )
    override val copyOptions
        : Optional[List[zio.aws.servicecatalog.model.CopyOption]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.copyOptions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.servicecatalog.model.CopyOption.wrap(item)
          }.toList
        )
    override val idempotencyToken: IdempotencyToken =
      zio.aws.servicecatalog.model.primitives
        .IdempotencyToken(impl.idempotencyToken())
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.CopyProductRequest
  ): zio.aws.servicecatalog.model.CopyProductRequest.ReadOnly = new Wrapper(
    impl
  )
}
