package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.servicecatalog.model.primitives.{
  AcceptLanguage,
  ProvisioningArtifactName,
  ProductViewName,
  IdempotencyToken,
  ProvisionedProductNameOrArn,
  PortfolioDisplayName,
  Id
}
import scala.jdk.CollectionConverters._
final case class UpdateProvisionedProductRequest(
    acceptLanguage: Optional[AcceptLanguage] = Optional.Absent,
    provisionedProductName: Optional[ProvisionedProductNameOrArn] =
      Optional.Absent,
    provisionedProductId: Optional[Id] = Optional.Absent,
    productId: Optional[Id] = Optional.Absent,
    productName: Optional[ProductViewName] = Optional.Absent,
    provisioningArtifactId: Optional[Id] = Optional.Absent,
    provisioningArtifactName: Optional[ProvisioningArtifactName] =
      Optional.Absent,
    pathId: Optional[Id] = Optional.Absent,
    pathName: Optional[PortfolioDisplayName] = Optional.Absent,
    provisioningParameters: Optional[
      Iterable[zio.aws.servicecatalog.model.UpdateProvisioningParameter]
    ] = Optional.Absent,
    provisioningPreferences: Optional[
      zio.aws.servicecatalog.model.UpdateProvisioningPreferences
    ] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.servicecatalog.model.Tag]] =
      Optional.Absent,
    updateToken: IdempotencyToken
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.UpdateProvisionedProductRequest = {
    import UpdateProvisionedProductRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.UpdateProvisionedProductRequest
      .builder()
      .optionallyWith(
        acceptLanguage.map(value =>
          AcceptLanguage.unwrap(value): java.lang.String
        )
      )(_.acceptLanguage)
      .optionallyWith(
        provisionedProductName.map(value =>
          ProvisionedProductNameOrArn.unwrap(value): java.lang.String
        )
      )(_.provisionedProductName)
      .optionallyWith(
        provisionedProductId.map(value => Id.unwrap(value): java.lang.String)
      )(_.provisionedProductId)
      .optionallyWith(
        productId.map(value => Id.unwrap(value): java.lang.String)
      )(_.productId)
      .optionallyWith(
        productName.map(value =>
          ProductViewName.unwrap(value): java.lang.String
        )
      )(_.productName)
      .optionallyWith(
        provisioningArtifactId.map(value => Id.unwrap(value): java.lang.String)
      )(_.provisioningArtifactId)
      .optionallyWith(
        provisioningArtifactName.map(value =>
          ProvisioningArtifactName.unwrap(value): java.lang.String
        )
      )(_.provisioningArtifactName)
      .optionallyWith(pathId.map(value => Id.unwrap(value): java.lang.String))(
        _.pathId
      )
      .optionallyWith(
        pathName.map(value =>
          PortfolioDisplayName.unwrap(value): java.lang.String
        )
      )(_.pathName)
      .optionallyWith(
        provisioningParameters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.provisioningParameters)
      .optionallyWith(
        provisioningPreferences.map(value => value.buildAwsValue())
      )(_.provisioningPreferences)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .updateToken(IdempotencyToken.unwrap(updateToken): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.UpdateProvisionedProductRequest.ReadOnly =
    zio.aws.servicecatalog.model.UpdateProvisionedProductRequest
      .wrap(buildAwsValue())
}
object UpdateProvisionedProductRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.UpdateProvisionedProductRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.servicecatalog.model.UpdateProvisionedProductRequest =
      zio.aws.servicecatalog.model.UpdateProvisionedProductRequest(
        acceptLanguage.map(value => value),
        provisionedProductName.map(value => value),
        provisionedProductId.map(value => value),
        productId.map(value => value),
        productName.map(value => value),
        provisioningArtifactId.map(value => value),
        provisioningArtifactName.map(value => value),
        pathId.map(value => value),
        pathName.map(value => value),
        provisioningParameters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        provisioningPreferences.map(value => value.asEditable),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        updateToken
      )
    def acceptLanguage: Optional[AcceptLanguage]
    def provisionedProductName: Optional[ProvisionedProductNameOrArn]
    def provisionedProductId: Optional[Id]
    def productId: Optional[Id]
    def productName: Optional[ProductViewName]
    def provisioningArtifactId: Optional[Id]
    def provisioningArtifactName: Optional[ProvisioningArtifactName]
    def pathId: Optional[Id]
    def pathName: Optional[PortfolioDisplayName]
    def provisioningParameters: Optional[
      List[zio.aws.servicecatalog.model.UpdateProvisioningParameter.ReadOnly]
    ]
    def provisioningPreferences: Optional[
      zio.aws.servicecatalog.model.UpdateProvisioningPreferences.ReadOnly
    ]
    def tags: Optional[List[zio.aws.servicecatalog.model.Tag.ReadOnly]]
    def updateToken: IdempotencyToken
    def getAcceptLanguage: ZIO[Any, AwsError, AcceptLanguage] =
      AwsError.unwrapOptionField("acceptLanguage", acceptLanguage)
    def getProvisionedProductName
        : ZIO[Any, AwsError, ProvisionedProductNameOrArn] = AwsError
      .unwrapOptionField("provisionedProductName", provisionedProductName)
    def getProvisionedProductId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("provisionedProductId", provisionedProductId)
    def getProductId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("productId", productId)
    def getProductName: ZIO[Any, AwsError, ProductViewName] =
      AwsError.unwrapOptionField("productName", productName)
    def getProvisioningArtifactId: ZIO[Any, AwsError, Id] = AwsError
      .unwrapOptionField("provisioningArtifactId", provisioningArtifactId)
    def getProvisioningArtifactName
        : ZIO[Any, AwsError, ProvisioningArtifactName] = AwsError
      .unwrapOptionField("provisioningArtifactName", provisioningArtifactName)
    def getPathId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("pathId", pathId)
    def getPathName: ZIO[Any, AwsError, PortfolioDisplayName] =
      AwsError.unwrapOptionField("pathName", pathName)
    def getProvisioningParameters: ZIO[Any, AwsError, List[
      zio.aws.servicecatalog.model.UpdateProvisioningParameter.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "provisioningParameters",
      provisioningParameters
    )
    def getProvisioningPreferences: ZIO[
      Any,
      AwsError,
      zio.aws.servicecatalog.model.UpdateProvisioningPreferences.ReadOnly
    ] = AwsError.unwrapOptionField(
      "provisioningPreferences",
      provisioningPreferences
    )
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.servicecatalog.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getUpdateToken: ZIO[Any, Nothing, IdempotencyToken] =
      ZIO.succeed(updateToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.UpdateProvisionedProductRequest
  ) extends zio.aws.servicecatalog.model.UpdateProvisionedProductRequest.ReadOnly {
    override val acceptLanguage: Optional[AcceptLanguage] =
      zio.aws.core.internal
        .optionalFromNullable(impl.acceptLanguage())
        .map(value =>
          zio.aws.servicecatalog.model.primitives.AcceptLanguage(value)
        )
    override val provisionedProductName: Optional[ProvisionedProductNameOrArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.provisionedProductName())
        .map(value =>
          zio.aws.servicecatalog.model.primitives
            .ProvisionedProductNameOrArn(value)
        )
    override val provisionedProductId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.provisionedProductId())
      .map(value => zio.aws.servicecatalog.model.primitives.Id(value))
    override val productId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.productId())
      .map(value => zio.aws.servicecatalog.model.primitives.Id(value))
    override val productName: Optional[ProductViewName] = zio.aws.core.internal
      .optionalFromNullable(impl.productName())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.ProductViewName(value)
      )
    override val provisioningArtifactId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.provisioningArtifactId())
      .map(value => zio.aws.servicecatalog.model.primitives.Id(value))
    override val provisioningArtifactName: Optional[ProvisioningArtifactName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.provisioningArtifactName())
        .map(value =>
          zio.aws.servicecatalog.model.primitives
            .ProvisioningArtifactName(value)
        )
    override val pathId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.pathId())
      .map(value => zio.aws.servicecatalog.model.primitives.Id(value))
    override val pathName: Optional[PortfolioDisplayName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pathName())
        .map(value =>
          zio.aws.servicecatalog.model.primitives.PortfolioDisplayName(value)
        )
    override val provisioningParameters: Optional[
      List[zio.aws.servicecatalog.model.UpdateProvisioningParameter.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.provisioningParameters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.servicecatalog.model.UpdateProvisioningParameter.wrap(item)
        }.toList
      )
    override val provisioningPreferences: Optional[
      zio.aws.servicecatalog.model.UpdateProvisioningPreferences.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.provisioningPreferences())
      .map(value =>
        zio.aws.servicecatalog.model.UpdateProvisioningPreferences.wrap(value)
      )
    override val tags
        : Optional[List[zio.aws.servicecatalog.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.servicecatalog.model.Tag.wrap(item)
          }.toList
        )
    override val updateToken: IdempotencyToken =
      zio.aws.servicecatalog.model.primitives
        .IdempotencyToken(impl.updateToken())
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.UpdateProvisionedProductRequest
  ): zio.aws.servicecatalog.model.UpdateProvisionedProductRequest.ReadOnly =
    new Wrapper(impl)
}
