package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.servicecatalog.model.primitives.{TagOptionValue, TagOptionKey}
import scala.jdk.CollectionConverters._
final case class TagOptionSummary(
    key: Optional[TagOptionKey] = Optional.Absent,
    values: Optional[Iterable[TagOptionValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.TagOptionSummary = {
    import TagOptionSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.TagOptionSummary
      .builder()
      .optionallyWith(
        key.map(value => TagOptionKey.unwrap(value): java.lang.String)
      )(_.key)
      .optionallyWith(
        values.map(value =>
          value.map { item =>
            TagOptionValue.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.values)
      .build()
  }
  def asReadOnly: zio.aws.servicecatalog.model.TagOptionSummary.ReadOnly =
    zio.aws.servicecatalog.model.TagOptionSummary.wrap(buildAwsValue())
}
object TagOptionSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.TagOptionSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicecatalog.model.TagOptionSummary =
      zio.aws.servicecatalog.model
        .TagOptionSummary(key.map(value => value), values.map(value => value))
    def key: Optional[TagOptionKey]
    def values: Optional[List[TagOptionValue]]
    def getKey: ZIO[Any, AwsError, TagOptionKey] =
      AwsError.unwrapOptionField("key", key)
    def getValues: ZIO[Any, AwsError, List[TagOptionValue]] =
      AwsError.unwrapOptionField("values", values)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.TagOptionSummary
  ) extends zio.aws.servicecatalog.model.TagOptionSummary.ReadOnly {
    override val key: Optional[TagOptionKey] = zio.aws.core.internal
      .optionalFromNullable(impl.key())
      .map(value => zio.aws.servicecatalog.model.primitives.TagOptionKey(value))
    override val values: Optional[List[TagOptionValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.values())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.servicecatalog.model.primitives.TagOptionValue(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.TagOptionSummary
  ): zio.aws.servicecatalog.model.TagOptionSummary.ReadOnly = new Wrapper(impl)
}
