package zio.aws.servicecatalog.model
import scala.jdk.CollectionConverters._
sealed trait ServiceActionDefinitionType {
  def unwrap: software.amazon.awssdk.services.servicecatalog.model.ServiceActionDefinitionType
}
object ServiceActionDefinitionType {
  def wrap(
      value: software.amazon.awssdk.services.servicecatalog.model.ServiceActionDefinitionType
  ): zio.aws.servicecatalog.model.ServiceActionDefinitionType = value match {
    case software.amazon.awssdk.services.servicecatalog.model.ServiceActionDefinitionType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.servicecatalog.model.ServiceActionDefinitionType.SSM_AUTOMATION =>
      val r = SSM_AUTOMATION
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.servicecatalog.model.ServiceActionDefinitionType {
    override def unwrap
        : software.amazon.awssdk.services.servicecatalog.model.ServiceActionDefinitionType =
      software.amazon.awssdk.services.servicecatalog.model.ServiceActionDefinitionType.UNKNOWN_TO_SDK_VERSION
  }
  case object SSM_AUTOMATION
      extends zio.aws.servicecatalog.model.ServiceActionDefinitionType {
    override def unwrap
        : software.amazon.awssdk.services.servicecatalog.model.ServiceActionDefinitionType =
      software.amazon.awssdk.services.servicecatalog.model.ServiceActionDefinitionType.SSM_AUTOMATION
  }
}
