package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.servicecatalog.model.primitives.{
  Description,
  OutputValue,
  OutputKey
}
import scala.jdk.CollectionConverters._
final case class RecordOutput(
    outputKey: Optional[OutputKey] = Optional.Absent,
    outputValue: Optional[OutputValue] = Optional.Absent,
    description: Optional[Description] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.RecordOutput = {
    import RecordOutput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.RecordOutput
      .builder()
      .optionallyWith(
        outputKey.map(value => OutputKey.unwrap(value): java.lang.String)
      )(_.outputKey)
      .optionallyWith(
        outputValue.map(value => OutputValue.unwrap(value): java.lang.String)
      )(_.outputValue)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .build()
  }
  def asReadOnly: zio.aws.servicecatalog.model.RecordOutput.ReadOnly =
    zio.aws.servicecatalog.model.RecordOutput.wrap(buildAwsValue())
}
object RecordOutput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.RecordOutput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicecatalog.model.RecordOutput =
      zio.aws.servicecatalog.model.RecordOutput(
        outputKey.map(value => value),
        outputValue.map(value => value),
        description.map(value => value)
      )
    def outputKey: Optional[OutputKey]
    def outputValue: Optional[OutputValue]
    def description: Optional[Description]
    def getOutputKey: ZIO[Any, AwsError, OutputKey] =
      AwsError.unwrapOptionField("outputKey", outputKey)
    def getOutputValue: ZIO[Any, AwsError, OutputValue] =
      AwsError.unwrapOptionField("outputValue", outputValue)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.RecordOutput
  ) extends zio.aws.servicecatalog.model.RecordOutput.ReadOnly {
    override val outputKey: Optional[OutputKey] = zio.aws.core.internal
      .optionalFromNullable(impl.outputKey())
      .map(value => zio.aws.servicecatalog.model.primitives.OutputKey(value))
    override val outputValue: Optional[OutputValue] = zio.aws.core.internal
      .optionalFromNullable(impl.outputValue())
      .map(value => zio.aws.servicecatalog.model.primitives.OutputValue(value))
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.servicecatalog.model.primitives.Description(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.RecordOutput
  ): zio.aws.servicecatalog.model.RecordOutput.ReadOnly = new Wrapper(impl)
}
