package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.servicecatalog.model.primitives.{
  ProvisionedProductName,
  Id,
  ProvisionedProductPlanName
}
import scala.jdk.CollectionConverters._
final case class ProvisionedProductPlanSummary(
    planName: Optional[ProvisionedProductPlanName] = Optional.Absent,
    planId: Optional[Id] = Optional.Absent,
    provisionProductId: Optional[Id] = Optional.Absent,
    provisionProductName: Optional[ProvisionedProductName] = Optional.Absent,
    planType: Optional[
      zio.aws.servicecatalog.model.ProvisionedProductPlanType
    ] = Optional.Absent,
    provisioningArtifactId: Optional[Id] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.ProvisionedProductPlanSummary = {
    import ProvisionedProductPlanSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.ProvisionedProductPlanSummary
      .builder()
      .optionallyWith(
        planName.map(value =>
          ProvisionedProductPlanName.unwrap(value): java.lang.String
        )
      )(_.planName)
      .optionallyWith(planId.map(value => Id.unwrap(value): java.lang.String))(
        _.planId
      )
      .optionallyWith(
        provisionProductId.map(value => Id.unwrap(value): java.lang.String)
      )(_.provisionProductId)
      .optionallyWith(
        provisionProductName.map(value =>
          ProvisionedProductName.unwrap(value): java.lang.String
        )
      )(_.provisionProductName)
      .optionallyWith(planType.map(value => value.unwrap))(_.planType)
      .optionallyWith(
        provisioningArtifactId.map(value => Id.unwrap(value): java.lang.String)
      )(_.provisioningArtifactId)
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.ProvisionedProductPlanSummary.ReadOnly =
    zio.aws.servicecatalog.model.ProvisionedProductPlanSummary
      .wrap(buildAwsValue())
}
object ProvisionedProductPlanSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.ProvisionedProductPlanSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicecatalog.model.ProvisionedProductPlanSummary =
      zio.aws.servicecatalog.model.ProvisionedProductPlanSummary(
        planName.map(value => value),
        planId.map(value => value),
        provisionProductId.map(value => value),
        provisionProductName.map(value => value),
        planType.map(value => value),
        provisioningArtifactId.map(value => value)
      )
    def planName: Optional[ProvisionedProductPlanName]
    def planId: Optional[Id]
    def provisionProductId: Optional[Id]
    def provisionProductName: Optional[ProvisionedProductName]
    def planType
        : Optional[zio.aws.servicecatalog.model.ProvisionedProductPlanType]
    def provisioningArtifactId: Optional[Id]
    def getPlanName: ZIO[Any, AwsError, ProvisionedProductPlanName] =
      AwsError.unwrapOptionField("planName", planName)
    def getPlanId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("planId", planId)
    def getProvisionProductId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("provisionProductId", provisionProductId)
    def getProvisionProductName: ZIO[Any, AwsError, ProvisionedProductName] =
      AwsError.unwrapOptionField("provisionProductName", provisionProductName)
    def getPlanType: ZIO[
      Any,
      AwsError,
      zio.aws.servicecatalog.model.ProvisionedProductPlanType
    ] = AwsError.unwrapOptionField("planType", planType)
    def getProvisioningArtifactId: ZIO[Any, AwsError, Id] = AwsError
      .unwrapOptionField("provisioningArtifactId", provisioningArtifactId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.ProvisionedProductPlanSummary
  ) extends zio.aws.servicecatalog.model.ProvisionedProductPlanSummary.ReadOnly {
    override val planName: Optional[ProvisionedProductPlanName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.planName())
        .map(value =>
          zio.aws.servicecatalog.model.primitives
            .ProvisionedProductPlanName(value)
        )
    override val planId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.planId())
      .map(value => zio.aws.servicecatalog.model.primitives.Id(value))
    override val provisionProductId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.provisionProductId())
      .map(value => zio.aws.servicecatalog.model.primitives.Id(value))
    override val provisionProductName: Optional[ProvisionedProductName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.provisionProductName())
        .map(value =>
          zio.aws.servicecatalog.model.primitives.ProvisionedProductName(value)
        )
    override val planType
        : Optional[zio.aws.servicecatalog.model.ProvisionedProductPlanType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.planType())
        .map(value =>
          zio.aws.servicecatalog.model.ProvisionedProductPlanType.wrap(value)
        )
    override val provisioningArtifactId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.provisioningArtifactId())
      .map(value => zio.aws.servicecatalog.model.primitives.Id(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.ProvisionedProductPlanSummary
  ): zio.aws.servicecatalog.model.ProvisionedProductPlanSummary.ReadOnly =
    new Wrapper(impl)
}
