package zio.aws.servicecatalog.model
import scala.jdk.CollectionConverters._
sealed trait OrganizationNodeType {
  def unwrap: software.amazon.awssdk.services.servicecatalog.model.OrganizationNodeType
}
object OrganizationNodeType {
  def wrap(
      value: software.amazon.awssdk.services.servicecatalog.model.OrganizationNodeType
  ): zio.aws.servicecatalog.model.OrganizationNodeType = value match {
    case software.amazon.awssdk.services.servicecatalog.model.OrganizationNodeType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.servicecatalog.model.OrganizationNodeType.ORGANIZATION =>
      val r = ORGANIZATION
      r
    case software.amazon.awssdk.services.servicecatalog.model.OrganizationNodeType.ORGANIZATIONAL_UNIT =>
      val r = ORGANIZATIONAL_UNIT
      r
    case software.amazon.awssdk.services.servicecatalog.model.OrganizationNodeType.ACCOUNT =>
      val r = ACCOUNT
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.servicecatalog.model.OrganizationNodeType {
    override def unwrap
        : software.amazon.awssdk.services.servicecatalog.model.OrganizationNodeType =
      software.amazon.awssdk.services.servicecatalog.model.OrganizationNodeType.UNKNOWN_TO_SDK_VERSION
  }
  case object ORGANIZATION
      extends zio.aws.servicecatalog.model.OrganizationNodeType {
    override def unwrap
        : software.amazon.awssdk.services.servicecatalog.model.OrganizationNodeType =
      software.amazon.awssdk.services.servicecatalog.model.OrganizationNodeType.ORGANIZATION
  }
  case object ORGANIZATIONAL_UNIT
      extends zio.aws.servicecatalog.model.OrganizationNodeType {
    override def unwrap
        : software.amazon.awssdk.services.servicecatalog.model.OrganizationNodeType =
      software.amazon.awssdk.services.servicecatalog.model.OrganizationNodeType.ORGANIZATIONAL_UNIT
  }
  case object ACCOUNT
      extends zio.aws.servicecatalog.model.OrganizationNodeType {
    override def unwrap
        : software.amazon.awssdk.services.servicecatalog.model.OrganizationNodeType =
      software.amazon.awssdk.services.servicecatalog.model.OrganizationNodeType.ACCOUNT
  }
}
