package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.servicecatalog.model.primitives.PageToken
import scala.jdk.CollectionConverters._
final case class ListServiceActionsResponse(
    serviceActionSummaries: Optional[
      Iterable[zio.aws.servicecatalog.model.ServiceActionSummary]
    ] = Optional.Absent,
    nextPageToken: Optional[PageToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.ListServiceActionsResponse = {
    import ListServiceActionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.ListServiceActionsResponse
      .builder()
      .optionallyWith(
        serviceActionSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.serviceActionSummaries)
      .optionallyWith(
        nextPageToken.map(value => PageToken.unwrap(value): java.lang.String)
      )(_.nextPageToken)
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.ListServiceActionsResponse.ReadOnly =
    zio.aws.servicecatalog.model.ListServiceActionsResponse
      .wrap(buildAwsValue())
}
object ListServiceActionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.ListServiceActionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicecatalog.model.ListServiceActionsResponse =
      zio.aws.servicecatalog.model.ListServiceActionsResponse(
        serviceActionSummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextPageToken.map(value => value)
      )
    def serviceActionSummaries: Optional[
      List[zio.aws.servicecatalog.model.ServiceActionSummary.ReadOnly]
    ]
    def nextPageToken: Optional[PageToken]
    def getServiceActionSummaries: ZIO[Any, AwsError, List[
      zio.aws.servicecatalog.model.ServiceActionSummary.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "serviceActionSummaries",
      serviceActionSummaries
    )
    def getNextPageToken: ZIO[Any, AwsError, PageToken] =
      AwsError.unwrapOptionField("nextPageToken", nextPageToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.ListServiceActionsResponse
  ) extends zio.aws.servicecatalog.model.ListServiceActionsResponse.ReadOnly {
    override val serviceActionSummaries: Optional[
      List[zio.aws.servicecatalog.model.ServiceActionSummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.serviceActionSummaries())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.servicecatalog.model.ServiceActionSummary.wrap(item)
        }.toList
      )
    override val nextPageToken: Optional[PageToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextPageToken())
      .map(value => zio.aws.servicecatalog.model.primitives.PageToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.ListServiceActionsResponse
  ): zio.aws.servicecatalog.model.ListServiceActionsResponse.ReadOnly =
    new Wrapper(impl)
}
