package zio.aws.servicecatalog.model
import zio.aws.servicecatalog.model.primitives.{
  PageToken,
  PageSize,
  Id,
  AcceptLanguage
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListBudgetsForResourceRequest(
    acceptLanguage: Optional[AcceptLanguage] = Optional.Absent,
    resourceId: Id,
    pageSize: Optional[PageSize] = Optional.Absent,
    pageToken: Optional[PageToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.ListBudgetsForResourceRequest = {
    import ListBudgetsForResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.ListBudgetsForResourceRequest
      .builder()
      .optionallyWith(
        acceptLanguage.map(value =>
          AcceptLanguage.unwrap(value): java.lang.String
        )
      )(_.acceptLanguage)
      .resourceId(Id.unwrap(resourceId): java.lang.String)
      .optionallyWith(pageSize.map(value => PageSize.unwrap(value): Integer))(
        _.pageSize
      )
      .optionallyWith(
        pageToken.map(value => PageToken.unwrap(value): java.lang.String)
      )(_.pageToken)
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.ListBudgetsForResourceRequest.ReadOnly =
    zio.aws.servicecatalog.model.ListBudgetsForResourceRequest
      .wrap(buildAwsValue())
}
object ListBudgetsForResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.ListBudgetsForResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicecatalog.model.ListBudgetsForResourceRequest =
      zio.aws.servicecatalog.model.ListBudgetsForResourceRequest(
        acceptLanguage.map(value => value),
        resourceId,
        pageSize.map(value => value),
        pageToken.map(value => value)
      )
    def acceptLanguage: Optional[AcceptLanguage]
    def resourceId: Id
    def pageSize: Optional[PageSize]
    def pageToken: Optional[PageToken]
    def getAcceptLanguage: ZIO[Any, AwsError, AcceptLanguage] =
      AwsError.unwrapOptionField("acceptLanguage", acceptLanguage)
    def getResourceId: ZIO[Any, Nothing, Id] = ZIO.succeed(resourceId)
    def getPageSize: ZIO[Any, AwsError, PageSize] =
      AwsError.unwrapOptionField("pageSize", pageSize)
    def getPageToken: ZIO[Any, AwsError, PageToken] =
      AwsError.unwrapOptionField("pageToken", pageToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.ListBudgetsForResourceRequest
  ) extends zio.aws.servicecatalog.model.ListBudgetsForResourceRequest.ReadOnly {
    override val acceptLanguage: Optional[AcceptLanguage] =
      zio.aws.core.internal
        .optionalFromNullable(impl.acceptLanguage())
        .map(value =>
          zio.aws.servicecatalog.model.primitives.AcceptLanguage(value)
        )
    override val resourceId: Id =
      zio.aws.servicecatalog.model.primitives.Id(impl.resourceId())
    override val pageSize: Optional[PageSize] = zio.aws.core.internal
      .optionalFromNullable(impl.pageSize())
      .map(value => zio.aws.servicecatalog.model.primitives.PageSize(value))
    override val pageToken: Optional[PageToken] = zio.aws.core.internal
      .optionalFromNullable(impl.pageToken())
      .map(value => zio.aws.servicecatalog.model.primitives.PageToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.ListBudgetsForResourceRequest
  ): zio.aws.servicecatalog.model.ListBudgetsForResourceRequest.ReadOnly =
    new Wrapper(impl)
}
