package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.servicecatalog.model.primitives.{AcceptLanguage, Id}
import scala.jdk.CollectionConverters._
final case class DisassociateServiceActionFromProvisioningArtifactRequest(
    productId: Id,
    provisioningArtifactId: Id,
    serviceActionId: Id,
    acceptLanguage: Optional[AcceptLanguage] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.DisassociateServiceActionFromProvisioningArtifactRequest = {
    import DisassociateServiceActionFromProvisioningArtifactRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.DisassociateServiceActionFromProvisioningArtifactRequest
      .builder()
      .productId(Id.unwrap(productId): java.lang.String)
      .provisioningArtifactId(
        Id.unwrap(provisioningArtifactId): java.lang.String
      )
      .serviceActionId(Id.unwrap(serviceActionId): java.lang.String)
      .optionallyWith(
        acceptLanguage.map(value =>
          AcceptLanguage.unwrap(value): java.lang.String
        )
      )(_.acceptLanguage)
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.DisassociateServiceActionFromProvisioningArtifactRequest.ReadOnly =
    zio.aws.servicecatalog.model.DisassociateServiceActionFromProvisioningArtifactRequest
      .wrap(buildAwsValue())
}
object DisassociateServiceActionFromProvisioningArtifactRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.DisassociateServiceActionFromProvisioningArtifactRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.servicecatalog.model.DisassociateServiceActionFromProvisioningArtifactRequest =
      zio.aws.servicecatalog.model
        .DisassociateServiceActionFromProvisioningArtifactRequest(
          productId,
          provisioningArtifactId,
          serviceActionId,
          acceptLanguage.map(value => value)
        )
    def productId: Id
    def provisioningArtifactId: Id
    def serviceActionId: Id
    def acceptLanguage: Optional[AcceptLanguage]
    def getProductId: ZIO[Any, Nothing, Id] = ZIO.succeed(productId)
    def getProvisioningArtifactId: ZIO[Any, Nothing, Id] =
      ZIO.succeed(provisioningArtifactId)
    def getServiceActionId: ZIO[Any, Nothing, Id] = ZIO.succeed(serviceActionId)
    def getAcceptLanguage: ZIO[Any, AwsError, AcceptLanguage] =
      AwsError.unwrapOptionField("acceptLanguage", acceptLanguage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.DisassociateServiceActionFromProvisioningArtifactRequest
  ) extends zio.aws.servicecatalog.model.DisassociateServiceActionFromProvisioningArtifactRequest.ReadOnly {
    override val productId: Id =
      zio.aws.servicecatalog.model.primitives.Id(impl.productId())
    override val provisioningArtifactId: Id =
      zio.aws.servicecatalog.model.primitives.Id(impl.provisioningArtifactId())
    override val serviceActionId: Id =
      zio.aws.servicecatalog.model.primitives.Id(impl.serviceActionId())
    override val acceptLanguage: Optional[AcceptLanguage] =
      zio.aws.core.internal
        .optionalFromNullable(impl.acceptLanguage())
        .map(value =>
          zio.aws.servicecatalog.model.primitives.AcceptLanguage(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.DisassociateServiceActionFromProvisioningArtifactRequest
  ): zio.aws.servicecatalog.model.DisassociateServiceActionFromProvisioningArtifactRequest.ReadOnly =
    new Wrapper(impl)
}
