package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeProvisioningParametersResponse(
    provisioningArtifactParameters: Optional[
      Iterable[zio.aws.servicecatalog.model.ProvisioningArtifactParameter]
    ] = Optional.Absent,
    constraintSummaries: Optional[
      Iterable[zio.aws.servicecatalog.model.ConstraintSummary]
    ] = Optional.Absent,
    usageInstructions: Optional[
      Iterable[zio.aws.servicecatalog.model.UsageInstruction]
    ] = Optional.Absent,
    tagOptions: Optional[
      Iterable[zio.aws.servicecatalog.model.TagOptionSummary]
    ] = Optional.Absent,
    provisioningArtifactPreferences: Optional[
      zio.aws.servicecatalog.model.ProvisioningArtifactPreferences
    ] = Optional.Absent,
    provisioningArtifactOutputs: Optional[
      Iterable[zio.aws.servicecatalog.model.ProvisioningArtifactOutput]
    ] = Optional.Absent,
    provisioningArtifactOutputKeys: Optional[
      Iterable[zio.aws.servicecatalog.model.ProvisioningArtifactOutput]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.DescribeProvisioningParametersResponse = {
    import DescribeProvisioningParametersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.DescribeProvisioningParametersResponse
      .builder()
      .optionallyWith(
        provisioningArtifactParameters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.provisioningArtifactParameters)
      .optionallyWith(
        constraintSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.constraintSummaries)
      .optionallyWith(
        usageInstructions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.usageInstructions)
      .optionallyWith(
        tagOptions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagOptions)
      .optionallyWith(
        provisioningArtifactPreferences.map(value => value.buildAwsValue())
      )(_.provisioningArtifactPreferences)
      .optionallyWith(
        provisioningArtifactOutputs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.provisioningArtifactOutputs)
      .optionallyWith(
        provisioningArtifactOutputKeys.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.provisioningArtifactOutputKeys)
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.DescribeProvisioningParametersResponse.ReadOnly =
    zio.aws.servicecatalog.model.DescribeProvisioningParametersResponse
      .wrap(buildAwsValue())
}
object DescribeProvisioningParametersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.DescribeProvisioningParametersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.servicecatalog.model.DescribeProvisioningParametersResponse =
      zio.aws.servicecatalog.model.DescribeProvisioningParametersResponse(
        provisioningArtifactParameters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        constraintSummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        usageInstructions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        tagOptions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        provisioningArtifactPreferences.map(value => value.asEditable),
        provisioningArtifactOutputs.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        provisioningArtifactOutputKeys.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def provisioningArtifactParameters: Optional[
      List[zio.aws.servicecatalog.model.ProvisioningArtifactParameter.ReadOnly]
    ]
    def constraintSummaries: Optional[
      List[zio.aws.servicecatalog.model.ConstraintSummary.ReadOnly]
    ]
    def usageInstructions
        : Optional[List[zio.aws.servicecatalog.model.UsageInstruction.ReadOnly]]
    def tagOptions
        : Optional[List[zio.aws.servicecatalog.model.TagOptionSummary.ReadOnly]]
    def provisioningArtifactPreferences: Optional[
      zio.aws.servicecatalog.model.ProvisioningArtifactPreferences.ReadOnly
    ]
    def provisioningArtifactOutputs: Optional[
      List[zio.aws.servicecatalog.model.ProvisioningArtifactOutput.ReadOnly]
    ]
    def provisioningArtifactOutputKeys: Optional[
      List[zio.aws.servicecatalog.model.ProvisioningArtifactOutput.ReadOnly]
    ]
    def getProvisioningArtifactParameters: ZIO[Any, AwsError, List[
      zio.aws.servicecatalog.model.ProvisioningArtifactParameter.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "provisioningArtifactParameters",
      provisioningArtifactParameters
    )
    def getConstraintSummaries: ZIO[Any, AwsError, List[
      zio.aws.servicecatalog.model.ConstraintSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("constraintSummaries", constraintSummaries)
    def getUsageInstructions: ZIO[Any, AwsError, List[
      zio.aws.servicecatalog.model.UsageInstruction.ReadOnly
    ]] = AwsError.unwrapOptionField("usageInstructions", usageInstructions)
    def getTagOptions: ZIO[Any, AwsError, List[
      zio.aws.servicecatalog.model.TagOptionSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("tagOptions", tagOptions)
    def getProvisioningArtifactPreferences: ZIO[
      Any,
      AwsError,
      zio.aws.servicecatalog.model.ProvisioningArtifactPreferences.ReadOnly
    ] = AwsError.unwrapOptionField(
      "provisioningArtifactPreferences",
      provisioningArtifactPreferences
    )
    def getProvisioningArtifactOutputs: ZIO[Any, AwsError, List[
      zio.aws.servicecatalog.model.ProvisioningArtifactOutput.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "provisioningArtifactOutputs",
      provisioningArtifactOutputs
    )
    def getProvisioningArtifactOutputKeys: ZIO[Any, AwsError, List[
      zio.aws.servicecatalog.model.ProvisioningArtifactOutput.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "provisioningArtifactOutputKeys",
      provisioningArtifactOutputKeys
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.DescribeProvisioningParametersResponse
  ) extends zio.aws.servicecatalog.model.DescribeProvisioningParametersResponse.ReadOnly {
    override val provisioningArtifactParameters: Optional[
      List[zio.aws.servicecatalog.model.ProvisioningArtifactParameter.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.provisioningArtifactParameters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.servicecatalog.model.ProvisioningArtifactParameter.wrap(item)
        }.toList
      )
    override val constraintSummaries: Optional[
      List[zio.aws.servicecatalog.model.ConstraintSummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.constraintSummaries())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.servicecatalog.model.ConstraintSummary.wrap(item)
        }.toList
      )
    override val usageInstructions: Optional[
      List[zio.aws.servicecatalog.model.UsageInstruction.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.usageInstructions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.servicecatalog.model.UsageInstruction.wrap(item)
        }.toList
      )
    override val tagOptions: Optional[
      List[zio.aws.servicecatalog.model.TagOptionSummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.tagOptions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.servicecatalog.model.TagOptionSummary.wrap(item)
        }.toList
      )
    override val provisioningArtifactPreferences: Optional[
      zio.aws.servicecatalog.model.ProvisioningArtifactPreferences.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.provisioningArtifactPreferences())
      .map(value =>
        zio.aws.servicecatalog.model.ProvisioningArtifactPreferences.wrap(value)
      )
    override val provisioningArtifactOutputs: Optional[
      List[zio.aws.servicecatalog.model.ProvisioningArtifactOutput.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.provisioningArtifactOutputs())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.servicecatalog.model.ProvisioningArtifactOutput.wrap(item)
        }.toList
      )
    override val provisioningArtifactOutputKeys: Optional[
      List[zio.aws.servicecatalog.model.ProvisioningArtifactOutput.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.provisioningArtifactOutputKeys())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.servicecatalog.model.ProvisioningArtifactOutput.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.DescribeProvisioningParametersResponse
  ): zio.aws.servicecatalog.model.DescribeProvisioningParametersResponse.ReadOnly =
    new Wrapper(impl)
}
