package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.servicecatalog.model.primitives.{
  AcceptLanguage,
  ConstraintType,
  ConstraintParameters,
  IdempotencyToken,
  ConstraintDescription,
  Id
}
import scala.jdk.CollectionConverters._
final case class CreateConstraintRequest(
    acceptLanguage: Optional[AcceptLanguage] = Optional.Absent,
    portfolioId: Id,
    productId: Id,
    parameters: ConstraintParameters,
    `type`: ConstraintType,
    description: Optional[ConstraintDescription] = Optional.Absent,
    idempotencyToken: IdempotencyToken
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.CreateConstraintRequest = {
    import CreateConstraintRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.CreateConstraintRequest
      .builder()
      .optionallyWith(
        acceptLanguage.map(value =>
          AcceptLanguage.unwrap(value): java.lang.String
        )
      )(_.acceptLanguage)
      .portfolioId(Id.unwrap(portfolioId): java.lang.String)
      .productId(Id.unwrap(productId): java.lang.String)
      .parameters(ConstraintParameters.unwrap(parameters): java.lang.String)
      .`type`(ConstraintType.unwrap(`type`): java.lang.String)
      .optionallyWith(
        description.map(value =>
          ConstraintDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .idempotencyToken(
        IdempotencyToken.unwrap(idempotencyToken): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.CreateConstraintRequest.ReadOnly =
    zio.aws.servicecatalog.model.CreateConstraintRequest.wrap(buildAwsValue())
}
object CreateConstraintRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.CreateConstraintRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicecatalog.model.CreateConstraintRequest =
      zio.aws.servicecatalog.model.CreateConstraintRequest(
        acceptLanguage.map(value => value),
        portfolioId,
        productId,
        parameters,
        `type`,
        description.map(value => value),
        idempotencyToken
      )
    def acceptLanguage: Optional[AcceptLanguage]
    def portfolioId: Id
    def productId: Id
    def parameters: ConstraintParameters
    def `type`: ConstraintType
    def description: Optional[ConstraintDescription]
    def idempotencyToken: IdempotencyToken
    def getAcceptLanguage: ZIO[Any, AwsError, AcceptLanguage] =
      AwsError.unwrapOptionField("acceptLanguage", acceptLanguage)
    def getPortfolioId: ZIO[Any, Nothing, Id] = ZIO.succeed(portfolioId)
    def getProductId: ZIO[Any, Nothing, Id] = ZIO.succeed(productId)
    def getParameters: ZIO[Any, Nothing, ConstraintParameters] =
      ZIO.succeed(parameters)
    def getType: ZIO[Any, Nothing, ConstraintType] = ZIO.succeed(`type`)
    def getDescription: ZIO[Any, AwsError, ConstraintDescription] =
      AwsError.unwrapOptionField("description", description)
    def getIdempotencyToken: ZIO[Any, Nothing, IdempotencyToken] =
      ZIO.succeed(idempotencyToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.CreateConstraintRequest
  ) extends zio.aws.servicecatalog.model.CreateConstraintRequest.ReadOnly {
    override val acceptLanguage: Optional[AcceptLanguage] =
      zio.aws.core.internal
        .optionalFromNullable(impl.acceptLanguage())
        .map(value =>
          zio.aws.servicecatalog.model.primitives.AcceptLanguage(value)
        )
    override val portfolioId: Id =
      zio.aws.servicecatalog.model.primitives.Id(impl.portfolioId())
    override val productId: Id =
      zio.aws.servicecatalog.model.primitives.Id(impl.productId())
    override val parameters: ConstraintParameters =
      zio.aws.servicecatalog.model.primitives
        .ConstraintParameters(impl.parameters())
    override val `type`: ConstraintType =
      zio.aws.servicecatalog.model.primitives.ConstraintType(impl.`type`())
    override val description: Optional[ConstraintDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.servicecatalog.model.primitives.ConstraintDescription(value)
        )
    override val idempotencyToken: IdempotencyToken =
      zio.aws.servicecatalog.model.primitives
        .IdempotencyToken(impl.idempotencyToken())
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.CreateConstraintRequest
  ): zio.aws.servicecatalog.model.CreateConstraintRequest.ReadOnly =
    new Wrapper(impl)
}
