package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.servicecatalog.model.primitives.{
  AcceptLanguage,
  ServiceActionDescription,
  ServiceActionDefinitionValue,
  ServiceActionName,
  Id
}
import scala.jdk.CollectionConverters._
final case class UpdateServiceActionRequest(
    id: Id,
    name: Optional[ServiceActionName] = Optional.Absent,
    definition: Optional[Map[
      zio.aws.servicecatalog.model.ServiceActionDefinitionKey,
      ServiceActionDefinitionValue
    ]] = Optional.Absent,
    description: Optional[ServiceActionDescription] = Optional.Absent,
    acceptLanguage: Optional[AcceptLanguage] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.UpdateServiceActionRequest = {
    import UpdateServiceActionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.UpdateServiceActionRequest
      .builder()
      .id(Id.unwrap(id): java.lang.String)
      .optionallyWith(
        name.map(value => ServiceActionName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        definition.map(value =>
          value
            .map({ case (key, value) =>
              key.unwrap.toString -> (ServiceActionDefinitionValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.definitionWithStrings)
      .optionallyWith(
        description.map(value =>
          ServiceActionDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        acceptLanguage.map(value =>
          AcceptLanguage.unwrap(value): java.lang.String
        )
      )(_.acceptLanguage)
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.UpdateServiceActionRequest.ReadOnly =
    zio.aws.servicecatalog.model.UpdateServiceActionRequest
      .wrap(buildAwsValue())
}
object UpdateServiceActionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.UpdateServiceActionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicecatalog.model.UpdateServiceActionRequest =
      zio.aws.servicecatalog.model.UpdateServiceActionRequest(
        id,
        name.map(value => value),
        definition.map(value => value),
        description.map(value => value),
        acceptLanguage.map(value => value)
      )
    def id: Id
    def name: Optional[ServiceActionName]
    def definition: Optional[Map[
      zio.aws.servicecatalog.model.ServiceActionDefinitionKey,
      ServiceActionDefinitionValue
    ]]
    def description: Optional[ServiceActionDescription]
    def acceptLanguage: Optional[AcceptLanguage]
    def getId: ZIO[Any, Nothing, Id] = ZIO.succeed(id)
    def getName: ZIO[Any, AwsError, ServiceActionName] =
      AwsError.unwrapOptionField("name", name)
    def getDefinition: ZIO[Any, AwsError, Map[
      zio.aws.servicecatalog.model.ServiceActionDefinitionKey,
      ServiceActionDefinitionValue
    ]] = AwsError.unwrapOptionField("definition", definition)
    def getDescription: ZIO[Any, AwsError, ServiceActionDescription] =
      AwsError.unwrapOptionField("description", description)
    def getAcceptLanguage: ZIO[Any, AwsError, AcceptLanguage] =
      AwsError.unwrapOptionField("acceptLanguage", acceptLanguage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.UpdateServiceActionRequest
  ) extends zio.aws.servicecatalog.model.UpdateServiceActionRequest.ReadOnly {
    override val id: Id = zio.aws.servicecatalog.model.primitives.Id(impl.id())
    override val name: Optional[ServiceActionName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.ServiceActionName(value)
      )
    override val definition: Optional[Map[
      zio.aws.servicecatalog.model.ServiceActionDefinitionKey,
      ServiceActionDefinitionValue
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.definition())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.servicecatalog.model.ServiceActionDefinitionKey
              .wrap(key) -> zio.aws.servicecatalog.model.primitives
              .ServiceActionDefinitionValue(value)
          })
          .toMap
      )
    override val description: Optional[ServiceActionDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.servicecatalog.model.primitives
            .ServiceActionDescription(value)
        )
    override val acceptLanguage: Optional[AcceptLanguage] =
      zio.aws.core.internal
        .optionalFromNullable(impl.acceptLanguage())
        .map(value =>
          zio.aws.servicecatalog.model.primitives.AcceptLanguage(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.UpdateServiceActionRequest
  ): zio.aws.servicecatalog.model.UpdateServiceActionRequest.ReadOnly =
    new Wrapper(impl)
}
