package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.servicecatalog.model.primitives.{
  AcceptLanguage,
  ProviderName,
  PortfolioDisplayName,
  Id,
  TagKey,
  PortfolioDescription
}
import scala.jdk.CollectionConverters._
final case class UpdatePortfolioRequest(
    acceptLanguage: Optional[AcceptLanguage] = Optional.Absent,
    id: Id,
    displayName: Optional[PortfolioDisplayName] = Optional.Absent,
    description: Optional[PortfolioDescription] = Optional.Absent,
    providerName: Optional[ProviderName] = Optional.Absent,
    addTags: Optional[Iterable[zio.aws.servicecatalog.model.Tag]] =
      Optional.Absent,
    removeTags: Optional[Iterable[TagKey]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.UpdatePortfolioRequest = {
    import UpdatePortfolioRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.UpdatePortfolioRequest
      .builder()
      .optionallyWith(
        acceptLanguage.map(value =>
          AcceptLanguage.unwrap(value): java.lang.String
        )
      )(_.acceptLanguage)
      .id(Id.unwrap(id): java.lang.String)
      .optionallyWith(
        displayName.map(value =>
          PortfolioDisplayName.unwrap(value): java.lang.String
        )
      )(_.displayName)
      .optionallyWith(
        description.map(value =>
          PortfolioDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        providerName.map(value => ProviderName.unwrap(value): java.lang.String)
      )(_.providerName)
      .optionallyWith(
        addTags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.addTags)
      .optionallyWith(
        removeTags.map(value =>
          value.map { item =>
            TagKey.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.removeTags)
      .build()
  }
  def asReadOnly: zio.aws.servicecatalog.model.UpdatePortfolioRequest.ReadOnly =
    zio.aws.servicecatalog.model.UpdatePortfolioRequest.wrap(buildAwsValue())
}
object UpdatePortfolioRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.UpdatePortfolioRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicecatalog.model.UpdatePortfolioRequest =
      zio.aws.servicecatalog.model.UpdatePortfolioRequest(
        acceptLanguage.map(value => value),
        id,
        displayName.map(value => value),
        description.map(value => value),
        providerName.map(value => value),
        addTags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        removeTags.map(value => value)
      )
    def acceptLanguage: Optional[AcceptLanguage]
    def id: Id
    def displayName: Optional[PortfolioDisplayName]
    def description: Optional[PortfolioDescription]
    def providerName: Optional[ProviderName]
    def addTags: Optional[List[zio.aws.servicecatalog.model.Tag.ReadOnly]]
    def removeTags: Optional[List[TagKey]]
    def getAcceptLanguage: ZIO[Any, AwsError, AcceptLanguage] =
      AwsError.unwrapOptionField("acceptLanguage", acceptLanguage)
    def getId: ZIO[Any, Nothing, Id] = ZIO.succeed(id)
    def getDisplayName: ZIO[Any, AwsError, PortfolioDisplayName] =
      AwsError.unwrapOptionField("displayName", displayName)
    def getDescription: ZIO[Any, AwsError, PortfolioDescription] =
      AwsError.unwrapOptionField("description", description)
    def getProviderName: ZIO[Any, AwsError, ProviderName] =
      AwsError.unwrapOptionField("providerName", providerName)
    def getAddTags
        : ZIO[Any, AwsError, List[zio.aws.servicecatalog.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("addTags", addTags)
    def getRemoveTags: ZIO[Any, AwsError, List[TagKey]] =
      AwsError.unwrapOptionField("removeTags", removeTags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.UpdatePortfolioRequest
  ) extends zio.aws.servicecatalog.model.UpdatePortfolioRequest.ReadOnly {
    override val acceptLanguage: Optional[AcceptLanguage] =
      zio.aws.core.internal
        .optionalFromNullable(impl.acceptLanguage())
        .map(value =>
          zio.aws.servicecatalog.model.primitives.AcceptLanguage(value)
        )
    override val id: Id = zio.aws.servicecatalog.model.primitives.Id(impl.id())
    override val displayName: Optional[PortfolioDisplayName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.displayName())
        .map(value =>
          zio.aws.servicecatalog.model.primitives.PortfolioDisplayName(value)
        )
    override val description: Optional[PortfolioDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.servicecatalog.model.primitives.PortfolioDescription(value)
        )
    override val providerName: Optional[ProviderName] = zio.aws.core.internal
      .optionalFromNullable(impl.providerName())
      .map(value => zio.aws.servicecatalog.model.primitives.ProviderName(value))
    override val addTags
        : Optional[List[zio.aws.servicecatalog.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.addTags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.servicecatalog.model.Tag.wrap(item)
          }.toList
        )
    override val removeTags: Optional[List[TagKey]] = zio.aws.core.internal
      .optionalFromNullable(impl.removeTags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.servicecatalog.model.primitives.TagKey(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.UpdatePortfolioRequest
  ): zio.aws.servicecatalog.model.UpdatePortfolioRequest.ReadOnly = new Wrapper(
    impl
  )
}
