package zio.aws.servicecatalog.model
import scala.jdk.CollectionConverters._
sealed trait ResourceAttribute {
  def unwrap
      : software.amazon.awssdk.services.servicecatalog.model.ResourceAttribute
}
object ResourceAttribute {
  def wrap(
      value: software.amazon.awssdk.services.servicecatalog.model.ResourceAttribute
  ): zio.aws.servicecatalog.model.ResourceAttribute = value match {
    case software.amazon.awssdk.services.servicecatalog.model.ResourceAttribute.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.servicecatalog.model.ResourceAttribute.PROPERTIES =>
      val r = PROPERTIES
      r
    case software.amazon.awssdk.services.servicecatalog.model.ResourceAttribute.METADATA =>
      val r = METADATA
      r
    case software.amazon.awssdk.services.servicecatalog.model.ResourceAttribute.CREATIONPOLICY =>
      val r = CREATIONPOLICY
      r
    case software.amazon.awssdk.services.servicecatalog.model.ResourceAttribute.UPDATEPOLICY =>
      val r = UPDATEPOLICY
      r
    case software.amazon.awssdk.services.servicecatalog.model.ResourceAttribute.DELETIONPOLICY =>
      val r = DELETIONPOLICY
      r
    case software.amazon.awssdk.services.servicecatalog.model.ResourceAttribute.TAGS =>
      val r = TAGS
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.servicecatalog.model.ResourceAttribute {
    override def unwrap
        : software.amazon.awssdk.services.servicecatalog.model.ResourceAttribute =
      software.amazon.awssdk.services.servicecatalog.model.ResourceAttribute.UNKNOWN_TO_SDK_VERSION
  }
  case object PROPERTIES
      extends zio.aws.servicecatalog.model.ResourceAttribute {
    override def unwrap
        : software.amazon.awssdk.services.servicecatalog.model.ResourceAttribute =
      software.amazon.awssdk.services.servicecatalog.model.ResourceAttribute.PROPERTIES
  }
  case object METADATA extends zio.aws.servicecatalog.model.ResourceAttribute {
    override def unwrap
        : software.amazon.awssdk.services.servicecatalog.model.ResourceAttribute =
      software.amazon.awssdk.services.servicecatalog.model.ResourceAttribute.METADATA
  }
  case object CREATIONPOLICY
      extends zio.aws.servicecatalog.model.ResourceAttribute {
    override def unwrap
        : software.amazon.awssdk.services.servicecatalog.model.ResourceAttribute =
      software.amazon.awssdk.services.servicecatalog.model.ResourceAttribute.CREATIONPOLICY
  }
  case object UPDATEPOLICY
      extends zio.aws.servicecatalog.model.ResourceAttribute {
    override def unwrap
        : software.amazon.awssdk.services.servicecatalog.model.ResourceAttribute =
      software.amazon.awssdk.services.servicecatalog.model.ResourceAttribute.UPDATEPOLICY
  }
  case object DELETIONPOLICY
      extends zio.aws.servicecatalog.model.ResourceAttribute {
    override def unwrap
        : software.amazon.awssdk.services.servicecatalog.model.ResourceAttribute =
      software.amazon.awssdk.services.servicecatalog.model.ResourceAttribute.DELETIONPOLICY
  }
  case object TAGS extends zio.aws.servicecatalog.model.ResourceAttribute {
    override def unwrap
        : software.amazon.awssdk.services.servicecatalog.model.ResourceAttribute =
      software.amazon.awssdk.services.servicecatalog.model.ResourceAttribute.TAGS
  }
}
