package zio.aws.servicecatalog.model
import zio.aws.servicecatalog.model.primitives.{
  ProvisionedProductPlanName,
  NotificationArn,
  ProvisionedProductName,
  UpdatedTime,
  CreatedTime,
  StatusMessage,
  Id
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class ProvisionedProductPlanDetails(
    createdTime: Optional[CreatedTime] = Optional.Absent,
    pathId: Optional[Id] = Optional.Absent,
    productId: Optional[Id] = Optional.Absent,
    planName: Optional[ProvisionedProductPlanName] = Optional.Absent,
    planId: Optional[Id] = Optional.Absent,
    provisionProductId: Optional[Id] = Optional.Absent,
    provisionProductName: Optional[ProvisionedProductName] = Optional.Absent,
    planType: Optional[
      zio.aws.servicecatalog.model.ProvisionedProductPlanType
    ] = Optional.Absent,
    provisioningArtifactId: Optional[Id] = Optional.Absent,
    status: Optional[
      zio.aws.servicecatalog.model.ProvisionedProductPlanStatus
    ] = Optional.Absent,
    updatedTime: Optional[UpdatedTime] = Optional.Absent,
    notificationArns: Optional[Iterable[NotificationArn]] = Optional.Absent,
    provisioningParameters: Optional[
      Iterable[zio.aws.servicecatalog.model.UpdateProvisioningParameter]
    ] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.servicecatalog.model.Tag]] =
      Optional.Absent,
    statusMessage: Optional[StatusMessage] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.ProvisionedProductPlanDetails = {
    import ProvisionedProductPlanDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.ProvisionedProductPlanDetails
      .builder()
      .optionallyWith(
        createdTime.map(value => CreatedTime.unwrap(value): Instant)
      )(_.createdTime)
      .optionallyWith(pathId.map(value => Id.unwrap(value): java.lang.String))(
        _.pathId
      )
      .optionallyWith(
        productId.map(value => Id.unwrap(value): java.lang.String)
      )(_.productId)
      .optionallyWith(
        planName.map(value =>
          ProvisionedProductPlanName.unwrap(value): java.lang.String
        )
      )(_.planName)
      .optionallyWith(planId.map(value => Id.unwrap(value): java.lang.String))(
        _.planId
      )
      .optionallyWith(
        provisionProductId.map(value => Id.unwrap(value): java.lang.String)
      )(_.provisionProductId)
      .optionallyWith(
        provisionProductName.map(value =>
          ProvisionedProductName.unwrap(value): java.lang.String
        )
      )(_.provisionProductName)
      .optionallyWith(planType.map(value => value.unwrap))(_.planType)
      .optionallyWith(
        provisioningArtifactId.map(value => Id.unwrap(value): java.lang.String)
      )(_.provisioningArtifactId)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        updatedTime.map(value => UpdatedTime.unwrap(value): Instant)
      )(_.updatedTime)
      .optionallyWith(
        notificationArns.map(value =>
          value.map { item =>
            NotificationArn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.notificationArns)
      .optionallyWith(
        provisioningParameters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.provisioningParameters)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        statusMessage.map(value =>
          StatusMessage.unwrap(value): java.lang.String
        )
      )(_.statusMessage)
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.ProvisionedProductPlanDetails.ReadOnly =
    zio.aws.servicecatalog.model.ProvisionedProductPlanDetails
      .wrap(buildAwsValue())
}
object ProvisionedProductPlanDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.ProvisionedProductPlanDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicecatalog.model.ProvisionedProductPlanDetails =
      zio.aws.servicecatalog.model.ProvisionedProductPlanDetails(
        createdTime.map(value => value),
        pathId.map(value => value),
        productId.map(value => value),
        planName.map(value => value),
        planId.map(value => value),
        provisionProductId.map(value => value),
        provisionProductName.map(value => value),
        planType.map(value => value),
        provisioningArtifactId.map(value => value),
        status.map(value => value),
        updatedTime.map(value => value),
        notificationArns.map(value => value),
        provisioningParameters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        statusMessage.map(value => value)
      )
    def createdTime: Optional[CreatedTime]
    def pathId: Optional[Id]
    def productId: Optional[Id]
    def planName: Optional[ProvisionedProductPlanName]
    def planId: Optional[Id]
    def provisionProductId: Optional[Id]
    def provisionProductName: Optional[ProvisionedProductName]
    def planType
        : Optional[zio.aws.servicecatalog.model.ProvisionedProductPlanType]
    def provisioningArtifactId: Optional[Id]
    def status
        : Optional[zio.aws.servicecatalog.model.ProvisionedProductPlanStatus]
    def updatedTime: Optional[UpdatedTime]
    def notificationArns: Optional[List[NotificationArn]]
    def provisioningParameters: Optional[
      List[zio.aws.servicecatalog.model.UpdateProvisioningParameter.ReadOnly]
    ]
    def tags: Optional[List[zio.aws.servicecatalog.model.Tag.ReadOnly]]
    def statusMessage: Optional[StatusMessage]
    def getCreatedTime: ZIO[Any, AwsError, CreatedTime] =
      AwsError.unwrapOptionField("createdTime", createdTime)
    def getPathId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("pathId", pathId)
    def getProductId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("productId", productId)
    def getPlanName: ZIO[Any, AwsError, ProvisionedProductPlanName] =
      AwsError.unwrapOptionField("planName", planName)
    def getPlanId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("planId", planId)
    def getProvisionProductId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("provisionProductId", provisionProductId)
    def getProvisionProductName: ZIO[Any, AwsError, ProvisionedProductName] =
      AwsError.unwrapOptionField("provisionProductName", provisionProductName)
    def getPlanType: ZIO[
      Any,
      AwsError,
      zio.aws.servicecatalog.model.ProvisionedProductPlanType
    ] = AwsError.unwrapOptionField("planType", planType)
    def getProvisioningArtifactId: ZIO[Any, AwsError, Id] = AwsError
      .unwrapOptionField("provisioningArtifactId", provisioningArtifactId)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.servicecatalog.model.ProvisionedProductPlanStatus
    ] = AwsError.unwrapOptionField("status", status)
    def getUpdatedTime: ZIO[Any, AwsError, UpdatedTime] =
      AwsError.unwrapOptionField("updatedTime", updatedTime)
    def getNotificationArns: ZIO[Any, AwsError, List[NotificationArn]] =
      AwsError.unwrapOptionField("notificationArns", notificationArns)
    def getProvisioningParameters: ZIO[Any, AwsError, List[
      zio.aws.servicecatalog.model.UpdateProvisioningParameter.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "provisioningParameters",
      provisioningParameters
    )
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.servicecatalog.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getStatusMessage: ZIO[Any, AwsError, StatusMessage] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.ProvisionedProductPlanDetails
  ) extends zio.aws.servicecatalog.model.ProvisionedProductPlanDetails.ReadOnly {
    override val createdTime: Optional[CreatedTime] = zio.aws.core.internal
      .optionalFromNullable(impl.createdTime())
      .map(value => zio.aws.servicecatalog.model.primitives.CreatedTime(value))
    override val pathId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.pathId())
      .map(value => zio.aws.servicecatalog.model.primitives.Id(value))
    override val productId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.productId())
      .map(value => zio.aws.servicecatalog.model.primitives.Id(value))
    override val planName: Optional[ProvisionedProductPlanName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.planName())
        .map(value =>
          zio.aws.servicecatalog.model.primitives
            .ProvisionedProductPlanName(value)
        )
    override val planId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.planId())
      .map(value => zio.aws.servicecatalog.model.primitives.Id(value))
    override val provisionProductId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.provisionProductId())
      .map(value => zio.aws.servicecatalog.model.primitives.Id(value))
    override val provisionProductName: Optional[ProvisionedProductName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.provisionProductName())
        .map(value =>
          zio.aws.servicecatalog.model.primitives.ProvisionedProductName(value)
        )
    override val planType
        : Optional[zio.aws.servicecatalog.model.ProvisionedProductPlanType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.planType())
        .map(value =>
          zio.aws.servicecatalog.model.ProvisionedProductPlanType.wrap(value)
        )
    override val provisioningArtifactId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.provisioningArtifactId())
      .map(value => zio.aws.servicecatalog.model.primitives.Id(value))
    override val status
        : Optional[zio.aws.servicecatalog.model.ProvisionedProductPlanStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.servicecatalog.model.ProvisionedProductPlanStatus.wrap(value)
        )
    override val updatedTime: Optional[UpdatedTime] = zio.aws.core.internal
      .optionalFromNullable(impl.updatedTime())
      .map(value => zio.aws.servicecatalog.model.primitives.UpdatedTime(value))
    override val notificationArns: Optional[List[NotificationArn]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.notificationArns())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.servicecatalog.model.primitives.NotificationArn(item)
          }.toList
        )
    override val provisioningParameters: Optional[
      List[zio.aws.servicecatalog.model.UpdateProvisioningParameter.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.provisioningParameters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.servicecatalog.model.UpdateProvisioningParameter.wrap(item)
        }.toList
      )
    override val tags
        : Optional[List[zio.aws.servicecatalog.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.servicecatalog.model.Tag.wrap(item)
          }.toList
        )
    override val statusMessage: Optional[StatusMessage] = zio.aws.core.internal
      .optionalFromNullable(impl.statusMessage())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.StatusMessage(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.ProvisionedProductPlanDetails
  ): zio.aws.servicecatalog.model.ProvisionedProductPlanDetails.ReadOnly =
    new Wrapper(impl)
}
