package zio.aws.servicecatalog.model
import scala.jdk.CollectionConverters._
sealed trait ProductViewSortBy {
  def unwrap
      : software.amazon.awssdk.services.servicecatalog.model.ProductViewSortBy
}
object ProductViewSortBy {
  def wrap(
      value: software.amazon.awssdk.services.servicecatalog.model.ProductViewSortBy
  ): zio.aws.servicecatalog.model.ProductViewSortBy = value match {
    case software.amazon.awssdk.services.servicecatalog.model.ProductViewSortBy.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.servicecatalog.model.ProductViewSortBy.TITLE =>
      val r = Title
      r
    case software.amazon.awssdk.services.servicecatalog.model.ProductViewSortBy.VERSION_COUNT =>
      val r = VersionCount
      r
    case software.amazon.awssdk.services.servicecatalog.model.ProductViewSortBy.CREATION_DATE =>
      val r = CreationDate
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.servicecatalog.model.ProductViewSortBy {
    override def unwrap
        : software.amazon.awssdk.services.servicecatalog.model.ProductViewSortBy =
      software.amazon.awssdk.services.servicecatalog.model.ProductViewSortBy.UNKNOWN_TO_SDK_VERSION
  }
  case object Title extends zio.aws.servicecatalog.model.ProductViewSortBy {
    override def unwrap
        : software.amazon.awssdk.services.servicecatalog.model.ProductViewSortBy =
      software.amazon.awssdk.services.servicecatalog.model.ProductViewSortBy.TITLE
  }
  case object VersionCount
      extends zio.aws.servicecatalog.model.ProductViewSortBy {
    override def unwrap
        : software.amazon.awssdk.services.servicecatalog.model.ProductViewSortBy =
      software.amazon.awssdk.services.servicecatalog.model.ProductViewSortBy.VERSION_COUNT
  }
  case object CreationDate
      extends zio.aws.servicecatalog.model.ProductViewSortBy {
    override def unwrap
        : software.amazon.awssdk.services.servicecatalog.model.ProductViewSortBy =
      software.amazon.awssdk.services.servicecatalog.model.ProductViewSortBy.CREATION_DATE
  }
}
