package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ParameterConstraints(
    allowedValues: Optional[Iterable[String]] = Optional.Absent,
    allowedPattern: Optional[String] = Optional.Absent,
    constraintDescription: Optional[String] = Optional.Absent,
    maxLength: Optional[String] = Optional.Absent,
    minLength: Optional[String] = Optional.Absent,
    maxValue: Optional[String] = Optional.Absent,
    minValue: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.ParameterConstraints = {
    import ParameterConstraints.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.ParameterConstraints
      .builder()
      .optionallyWith(
        allowedValues.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.allowedValues)
      .optionallyWith(allowedPattern.map(value => value: java.lang.String))(
        _.allowedPattern
      )
      .optionallyWith(
        constraintDescription.map(value => value: java.lang.String)
      )(_.constraintDescription)
      .optionallyWith(maxLength.map(value => value: java.lang.String))(
        _.maxLength
      )
      .optionallyWith(minLength.map(value => value: java.lang.String))(
        _.minLength
      )
      .optionallyWith(maxValue.map(value => value: java.lang.String))(
        _.maxValue
      )
      .optionallyWith(minValue.map(value => value: java.lang.String))(
        _.minValue
      )
      .build()
  }
  def asReadOnly: zio.aws.servicecatalog.model.ParameterConstraints.ReadOnly =
    zio.aws.servicecatalog.model.ParameterConstraints.wrap(buildAwsValue())
}
object ParameterConstraints {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.ParameterConstraints
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicecatalog.model.ParameterConstraints =
      zio.aws.servicecatalog.model.ParameterConstraints(
        allowedValues.map(value => value),
        allowedPattern.map(value => value),
        constraintDescription.map(value => value),
        maxLength.map(value => value),
        minLength.map(value => value),
        maxValue.map(value => value),
        minValue.map(value => value)
      )
    def allowedValues: Optional[List[String]]
    def allowedPattern: Optional[String]
    def constraintDescription: Optional[String]
    def maxLength: Optional[String]
    def minLength: Optional[String]
    def maxValue: Optional[String]
    def minValue: Optional[String]
    def getAllowedValues: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("allowedValues", allowedValues)
    def getAllowedPattern: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("allowedPattern", allowedPattern)
    def getConstraintDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("constraintDescription", constraintDescription)
    def getMaxLength: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("maxLength", maxLength)
    def getMinLength: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("minLength", minLength)
    def getMaxValue: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("maxValue", maxValue)
    def getMinValue: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("minValue", minValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.ParameterConstraints
  ) extends zio.aws.servicecatalog.model.ParameterConstraints.ReadOnly {
    override val allowedValues: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.allowedValues())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val allowedPattern: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.allowedPattern())
      .map(value => value: String)
    override val constraintDescription: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.constraintDescription())
      .map(value => value: String)
    override val maxLength: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.maxLength())
      .map(value => value: String)
    override val minLength: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.minLength())
      .map(value => value: String)
    override val maxValue: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.maxValue())
      .map(value => value: String)
    override val minValue: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.minValue())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.ParameterConstraints
  ): zio.aws.servicecatalog.model.ParameterConstraints.ReadOnly = new Wrapper(
    impl
  )
}
