package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.servicecatalog.model.primitives.TagOptionId
import scala.jdk.CollectionConverters._
final case class DescribeTagOptionRequest(id: TagOptionId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.DescribeTagOptionRequest = {
    import DescribeTagOptionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.DescribeTagOptionRequest
      .builder()
      .id(TagOptionId.unwrap(id): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.DescribeTagOptionRequest.ReadOnly =
    zio.aws.servicecatalog.model.DescribeTagOptionRequest.wrap(buildAwsValue())
}
object DescribeTagOptionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.DescribeTagOptionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicecatalog.model.DescribeTagOptionRequest =
      zio.aws.servicecatalog.model.DescribeTagOptionRequest(id)
    def id: TagOptionId
    def getId: ZIO[Any, Nothing, TagOptionId] = ZIO.succeed(id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.DescribeTagOptionRequest
  ) extends zio.aws.servicecatalog.model.DescribeTagOptionRequest.ReadOnly {
    override val id: TagOptionId =
      zio.aws.servicecatalog.model.primitives.TagOptionId(impl.id())
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.DescribeTagOptionRequest
  ): zio.aws.servicecatalog.model.DescribeTagOptionRequest.ReadOnly =
    new Wrapper(impl)
}
