package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeServiceActionResponse(
    serviceActionDetail: Optional[
      zio.aws.servicecatalog.model.ServiceActionDetail
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.DescribeServiceActionResponse = {
    import DescribeServiceActionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.DescribeServiceActionResponse
      .builder()
      .optionallyWith(serviceActionDetail.map(value => value.buildAwsValue()))(
        _.serviceActionDetail
      )
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.DescribeServiceActionResponse.ReadOnly =
    zio.aws.servicecatalog.model.DescribeServiceActionResponse
      .wrap(buildAwsValue())
}
object DescribeServiceActionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.DescribeServiceActionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicecatalog.model.DescribeServiceActionResponse =
      zio.aws.servicecatalog.model.DescribeServiceActionResponse(
        serviceActionDetail.map(value => value.asEditable)
      )
    def serviceActionDetail
        : Optional[zio.aws.servicecatalog.model.ServiceActionDetail.ReadOnly]
    def getServiceActionDetail: ZIO[
      Any,
      AwsError,
      zio.aws.servicecatalog.model.ServiceActionDetail.ReadOnly
    ] = AwsError.unwrapOptionField("serviceActionDetail", serviceActionDetail)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.DescribeServiceActionResponse
  ) extends zio.aws.servicecatalog.model.DescribeServiceActionResponse.ReadOnly {
    override val serviceActionDetail
        : Optional[zio.aws.servicecatalog.model.ServiceActionDetail.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serviceActionDetail())
        .map(value =>
          zio.aws.servicecatalog.model.ServiceActionDetail.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.DescribeServiceActionResponse
  ): zio.aws.servicecatalog.model.DescribeServiceActionResponse.ReadOnly =
    new Wrapper(impl)
}
