package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribePortfolioResponse(
    portfolioDetail: Optional[zio.aws.servicecatalog.model.PortfolioDetail] =
      Optional.Absent,
    tags: Optional[Iterable[zio.aws.servicecatalog.model.Tag]] =
      Optional.Absent,
    tagOptions: Optional[
      Iterable[zio.aws.servicecatalog.model.TagOptionDetail]
    ] = Optional.Absent,
    budgets: Optional[Iterable[zio.aws.servicecatalog.model.BudgetDetail]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.DescribePortfolioResponse = {
    import DescribePortfolioResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.DescribePortfolioResponse
      .builder()
      .optionallyWith(portfolioDetail.map(value => value.buildAwsValue()))(
        _.portfolioDetail
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        tagOptions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagOptions)
      .optionallyWith(
        budgets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.budgets)
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.DescribePortfolioResponse.ReadOnly =
    zio.aws.servicecatalog.model.DescribePortfolioResponse.wrap(buildAwsValue())
}
object DescribePortfolioResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.DescribePortfolioResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicecatalog.model.DescribePortfolioResponse =
      zio.aws.servicecatalog.model.DescribePortfolioResponse(
        portfolioDetail.map(value => value.asEditable),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        tagOptions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        budgets.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def portfolioDetail
        : Optional[zio.aws.servicecatalog.model.PortfolioDetail.ReadOnly]
    def tags: Optional[List[zio.aws.servicecatalog.model.Tag.ReadOnly]]
    def tagOptions
        : Optional[List[zio.aws.servicecatalog.model.TagOptionDetail.ReadOnly]]
    def budgets
        : Optional[List[zio.aws.servicecatalog.model.BudgetDetail.ReadOnly]]
    def getPortfolioDetail: ZIO[
      Any,
      AwsError,
      zio.aws.servicecatalog.model.PortfolioDetail.ReadOnly
    ] = AwsError.unwrapOptionField("portfolioDetail", portfolioDetail)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.servicecatalog.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getTagOptions: ZIO[Any, AwsError, List[
      zio.aws.servicecatalog.model.TagOptionDetail.ReadOnly
    ]] = AwsError.unwrapOptionField("tagOptions", tagOptions)
    def getBudgets: ZIO[Any, AwsError, List[
      zio.aws.servicecatalog.model.BudgetDetail.ReadOnly
    ]] = AwsError.unwrapOptionField("budgets", budgets)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.DescribePortfolioResponse
  ) extends zio.aws.servicecatalog.model.DescribePortfolioResponse.ReadOnly {
    override val portfolioDetail
        : Optional[zio.aws.servicecatalog.model.PortfolioDetail.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.portfolioDetail())
        .map(value => zio.aws.servicecatalog.model.PortfolioDetail.wrap(value))
    override val tags
        : Optional[List[zio.aws.servicecatalog.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.servicecatalog.model.Tag.wrap(item)
          }.toList
        )
    override val tagOptions: Optional[
      List[zio.aws.servicecatalog.model.TagOptionDetail.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.tagOptions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.servicecatalog.model.TagOptionDetail.wrap(item)
        }.toList
      )
    override val budgets
        : Optional[List[zio.aws.servicecatalog.model.BudgetDetail.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.budgets())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.servicecatalog.model.BudgetDetail.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.DescribePortfolioResponse
  ): zio.aws.servicecatalog.model.DescribePortfolioResponse.ReadOnly =
    new Wrapper(impl)
}
