package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.servicecatalog.model.primitives.{AccountId, Id, AcceptLanguage}
import scala.jdk.CollectionConverters._
final case class DeletePortfolioShareRequest(
    acceptLanguage: Optional[AcceptLanguage] = Optional.Absent,
    portfolioId: Id,
    accountId: Optional[AccountId] = Optional.Absent,
    organizationNode: Optional[zio.aws.servicecatalog.model.OrganizationNode] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.DeletePortfolioShareRequest = {
    import DeletePortfolioShareRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.DeletePortfolioShareRequest
      .builder()
      .optionallyWith(
        acceptLanguage.map(value =>
          AcceptLanguage.unwrap(value): java.lang.String
        )
      )(_.acceptLanguage)
      .portfolioId(Id.unwrap(portfolioId): java.lang.String)
      .optionallyWith(
        accountId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.accountId)
      .optionallyWith(organizationNode.map(value => value.buildAwsValue()))(
        _.organizationNode
      )
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.DeletePortfolioShareRequest.ReadOnly =
    zio.aws.servicecatalog.model.DeletePortfolioShareRequest
      .wrap(buildAwsValue())
}
object DeletePortfolioShareRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.DeletePortfolioShareRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicecatalog.model.DeletePortfolioShareRequest =
      zio.aws.servicecatalog.model.DeletePortfolioShareRequest(
        acceptLanguage.map(value => value),
        portfolioId,
        accountId.map(value => value),
        organizationNode.map(value => value.asEditable)
      )
    def acceptLanguage: Optional[AcceptLanguage]
    def portfolioId: Id
    def accountId: Optional[AccountId]
    def organizationNode
        : Optional[zio.aws.servicecatalog.model.OrganizationNode.ReadOnly]
    def getAcceptLanguage: ZIO[Any, AwsError, AcceptLanguage] =
      AwsError.unwrapOptionField("acceptLanguage", acceptLanguage)
    def getPortfolioId: ZIO[Any, Nothing, Id] = ZIO.succeed(portfolioId)
    def getAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getOrganizationNode: ZIO[
      Any,
      AwsError,
      zio.aws.servicecatalog.model.OrganizationNode.ReadOnly
    ] = AwsError.unwrapOptionField("organizationNode", organizationNode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.DeletePortfolioShareRequest
  ) extends zio.aws.servicecatalog.model.DeletePortfolioShareRequest.ReadOnly {
    override val acceptLanguage: Optional[AcceptLanguage] =
      zio.aws.core.internal
        .optionalFromNullable(impl.acceptLanguage())
        .map(value =>
          zio.aws.servicecatalog.model.primitives.AcceptLanguage(value)
        )
    override val portfolioId: Id =
      zio.aws.servicecatalog.model.primitives.Id(impl.portfolioId())
    override val accountId: Optional[AccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.accountId())
      .map(value => zio.aws.servicecatalog.model.primitives.AccountId(value))
    override val organizationNode
        : Optional[zio.aws.servicecatalog.model.OrganizationNode.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.organizationNode())
        .map(value => zio.aws.servicecatalog.model.OrganizationNode.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.DeletePortfolioShareRequest
  ): zio.aws.servicecatalog.model.DeletePortfolioShareRequest.ReadOnly =
    new Wrapper(impl)
}
