package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.servicecatalog.model.primitives.{AccountId, Id, AcceptLanguage}
import scala.jdk.CollectionConverters._
final case class CreatePortfolioShareRequest(
    acceptLanguage: Optional[AcceptLanguage] = Optional.Absent,
    portfolioId: Id,
    accountId: Optional[AccountId] = Optional.Absent,
    organizationNode: Optional[zio.aws.servicecatalog.model.OrganizationNode] =
      Optional.Absent,
    shareTagOptions: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.CreatePortfolioShareRequest = {
    import CreatePortfolioShareRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.CreatePortfolioShareRequest
      .builder()
      .optionallyWith(
        acceptLanguage.map(value =>
          AcceptLanguage.unwrap(value): java.lang.String
        )
      )(_.acceptLanguage)
      .portfolioId(Id.unwrap(portfolioId): java.lang.String)
      .optionallyWith(
        accountId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.accountId)
      .optionallyWith(organizationNode.map(value => value.buildAwsValue()))(
        _.organizationNode
      )
      .optionallyWith(shareTagOptions.map(value => value: java.lang.Boolean))(
        _.shareTagOptions
      )
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.CreatePortfolioShareRequest.ReadOnly =
    zio.aws.servicecatalog.model.CreatePortfolioShareRequest
      .wrap(buildAwsValue())
}
object CreatePortfolioShareRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.CreatePortfolioShareRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicecatalog.model.CreatePortfolioShareRequest =
      zio.aws.servicecatalog.model.CreatePortfolioShareRequest(
        acceptLanguage.map(value => value),
        portfolioId,
        accountId.map(value => value),
        organizationNode.map(value => value.asEditable),
        shareTagOptions.map(value => value)
      )
    def acceptLanguage: Optional[AcceptLanguage]
    def portfolioId: Id
    def accountId: Optional[AccountId]
    def organizationNode
        : Optional[zio.aws.servicecatalog.model.OrganizationNode.ReadOnly]
    def shareTagOptions: Optional[Boolean]
    def getAcceptLanguage: ZIO[Any, AwsError, AcceptLanguage] =
      AwsError.unwrapOptionField("acceptLanguage", acceptLanguage)
    def getPortfolioId: ZIO[Any, Nothing, Id] = ZIO.succeed(portfolioId)
    def getAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getOrganizationNode: ZIO[
      Any,
      AwsError,
      zio.aws.servicecatalog.model.OrganizationNode.ReadOnly
    ] = AwsError.unwrapOptionField("organizationNode", organizationNode)
    def getShareTagOptions: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("shareTagOptions", shareTagOptions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.CreatePortfolioShareRequest
  ) extends zio.aws.servicecatalog.model.CreatePortfolioShareRequest.ReadOnly {
    override val acceptLanguage: Optional[AcceptLanguage] =
      zio.aws.core.internal
        .optionalFromNullable(impl.acceptLanguage())
        .map(value =>
          zio.aws.servicecatalog.model.primitives.AcceptLanguage(value)
        )
    override val portfolioId: Id =
      zio.aws.servicecatalog.model.primitives.Id(impl.portfolioId())
    override val accountId: Optional[AccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.accountId())
      .map(value => zio.aws.servicecatalog.model.primitives.AccountId(value))
    override val organizationNode
        : Optional[zio.aws.servicecatalog.model.OrganizationNode.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.organizationNode())
        .map(value => zio.aws.servicecatalog.model.OrganizationNode.wrap(value))
    override val shareTagOptions: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.shareTagOptions())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.CreatePortfolioShareRequest
  ): zio.aws.servicecatalog.model.CreatePortfolioShareRequest.ReadOnly =
    new Wrapper(impl)
}
