package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.servicecatalog.model.primitives.Id
import scala.jdk.CollectionConverters._
final case class UpdatePortfolioShareResponse(
    portfolioShareToken: Optional[Id] = Optional.Absent,
    status: Optional[zio.aws.servicecatalog.model.ShareStatus] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.UpdatePortfolioShareResponse = {
    import UpdatePortfolioShareResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.UpdatePortfolioShareResponse
      .builder()
      .optionallyWith(
        portfolioShareToken.map(value => Id.unwrap(value): java.lang.String)
      )(_.portfolioShareToken)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.UpdatePortfolioShareResponse.ReadOnly =
    zio.aws.servicecatalog.model.UpdatePortfolioShareResponse
      .wrap(buildAwsValue())
}
object UpdatePortfolioShareResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.UpdatePortfolioShareResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicecatalog.model.UpdatePortfolioShareResponse =
      zio.aws.servicecatalog.model.UpdatePortfolioShareResponse(
        portfolioShareToken.map(value => value),
        status.map(value => value)
      )
    def portfolioShareToken: Optional[Id]
    def status: Optional[zio.aws.servicecatalog.model.ShareStatus]
    def getPortfolioShareToken: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("portfolioShareToken", portfolioShareToken)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.servicecatalog.model.ShareStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.UpdatePortfolioShareResponse
  ) extends zio.aws.servicecatalog.model.UpdatePortfolioShareResponse.ReadOnly {
    override val portfolioShareToken: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.portfolioShareToken())
      .map(value => zio.aws.servicecatalog.model.primitives.Id(value))
    override val status: Optional[zio.aws.servicecatalog.model.ShareStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.servicecatalog.model.ShareStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.UpdatePortfolioShareResponse
  ): zio.aws.servicecatalog.model.UpdatePortfolioShareResponse.ReadOnly =
    new Wrapper(impl)
}
