package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.servicecatalog.model.primitives.Id
import scala.jdk.CollectionConverters._
final case class ServiceActionAssociation(
    serviceActionId: Id,
    productId: Id,
    provisioningArtifactId: Id
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.ServiceActionAssociation = {
    import ServiceActionAssociation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.ServiceActionAssociation
      .builder()
      .serviceActionId(Id.unwrap(serviceActionId): java.lang.String)
      .productId(Id.unwrap(productId): java.lang.String)
      .provisioningArtifactId(
        Id.unwrap(provisioningArtifactId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.ServiceActionAssociation.ReadOnly =
    zio.aws.servicecatalog.model.ServiceActionAssociation.wrap(buildAwsValue())
}
object ServiceActionAssociation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.ServiceActionAssociation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicecatalog.model.ServiceActionAssociation =
      zio.aws.servicecatalog.model.ServiceActionAssociation(
        serviceActionId,
        productId,
        provisioningArtifactId
      )
    def serviceActionId: Id
    def productId: Id
    def provisioningArtifactId: Id
    def getServiceActionId: ZIO[Any, Nothing, Id] = ZIO.succeed(serviceActionId)
    def getProductId: ZIO[Any, Nothing, Id] = ZIO.succeed(productId)
    def getProvisioningArtifactId: ZIO[Any, Nothing, Id] =
      ZIO.succeed(provisioningArtifactId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.ServiceActionAssociation
  ) extends zio.aws.servicecatalog.model.ServiceActionAssociation.ReadOnly {
    override val serviceActionId: Id =
      zio.aws.servicecatalog.model.primitives.Id(impl.serviceActionId())
    override val productId: Id =
      zio.aws.servicecatalog.model.primitives.Id(impl.productId())
    override val provisioningArtifactId: Id =
      zio.aws.servicecatalog.model.primitives.Id(impl.provisioningArtifactId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.ServiceActionAssociation
  ): zio.aws.servicecatalog.model.ServiceActionAssociation.ReadOnly =
    new Wrapper(impl)
}
