package zio.aws.servicecatalog.model
import scala.jdk.CollectionConverters._
sealed trait ProductViewFilterBy {
  def unwrap
      : software.amazon.awssdk.services.servicecatalog.model.ProductViewFilterBy
}
object ProductViewFilterBy {
  def wrap(
      value: software.amazon.awssdk.services.servicecatalog.model.ProductViewFilterBy
  ): zio.aws.servicecatalog.model.ProductViewFilterBy = value match {
    case software.amazon.awssdk.services.servicecatalog.model.ProductViewFilterBy.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.servicecatalog.model.ProductViewFilterBy.FULL_TEXT_SEARCH =>
      val r = FullTextSearch
      r
    case software.amazon.awssdk.services.servicecatalog.model.ProductViewFilterBy.OWNER =>
      val r = Owner
      r
    case software.amazon.awssdk.services.servicecatalog.model.ProductViewFilterBy.PRODUCT_TYPE =>
      val r = ProductType
      r
    case software.amazon.awssdk.services.servicecatalog.model.ProductViewFilterBy.SOURCE_PRODUCT_ID =>
      val r = SourceProductId
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.servicecatalog.model.ProductViewFilterBy {
    override def unwrap
        : software.amazon.awssdk.services.servicecatalog.model.ProductViewFilterBy =
      software.amazon.awssdk.services.servicecatalog.model.ProductViewFilterBy.UNKNOWN_TO_SDK_VERSION
  }
  case object FullTextSearch
      extends zio.aws.servicecatalog.model.ProductViewFilterBy {
    override def unwrap
        : software.amazon.awssdk.services.servicecatalog.model.ProductViewFilterBy =
      software.amazon.awssdk.services.servicecatalog.model.ProductViewFilterBy.FULL_TEXT_SEARCH
  }
  case object Owner extends zio.aws.servicecatalog.model.ProductViewFilterBy {
    override def unwrap
        : software.amazon.awssdk.services.servicecatalog.model.ProductViewFilterBy =
      software.amazon.awssdk.services.servicecatalog.model.ProductViewFilterBy.OWNER
  }
  case object ProductType
      extends zio.aws.servicecatalog.model.ProductViewFilterBy {
    override def unwrap
        : software.amazon.awssdk.services.servicecatalog.model.ProductViewFilterBy =
      software.amazon.awssdk.services.servicecatalog.model.ProductViewFilterBy.PRODUCT_TYPE
  }
  case object SourceProductId
      extends zio.aws.servicecatalog.model.ProductViewFilterBy {
    override def unwrap
        : software.amazon.awssdk.services.servicecatalog.model.ProductViewFilterBy =
      software.amazon.awssdk.services.servicecatalog.model.ProductViewFilterBy.SOURCE_PRODUCT_ID
  }
}
