package zio.aws.servicecatalog.model
import zio.aws.servicecatalog.model.primitives.{
  CreationTime,
  ProviderName,
  ResourceARN,
  PortfolioDisplayName,
  Id,
  PortfolioDescription
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class PortfolioDetail(
    id: Optional[Id] = Optional.Absent,
    arn: Optional[ResourceARN] = Optional.Absent,
    displayName: Optional[PortfolioDisplayName] = Optional.Absent,
    description: Optional[PortfolioDescription] = Optional.Absent,
    createdTime: Optional[CreationTime] = Optional.Absent,
    providerName: Optional[ProviderName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.PortfolioDetail = {
    import PortfolioDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.PortfolioDetail
      .builder()
      .optionallyWith(id.map(value => Id.unwrap(value): java.lang.String))(_.id)
      .optionallyWith(
        arn.map(value => ResourceARN.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        displayName.map(value =>
          PortfolioDisplayName.unwrap(value): java.lang.String
        )
      )(_.displayName)
      .optionallyWith(
        description.map(value =>
          PortfolioDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        createdTime.map(value => CreationTime.unwrap(value): Instant)
      )(_.createdTime)
      .optionallyWith(
        providerName.map(value => ProviderName.unwrap(value): java.lang.String)
      )(_.providerName)
      .build()
  }
  def asReadOnly: zio.aws.servicecatalog.model.PortfolioDetail.ReadOnly =
    zio.aws.servicecatalog.model.PortfolioDetail.wrap(buildAwsValue())
}
object PortfolioDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.PortfolioDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicecatalog.model.PortfolioDetail =
      zio.aws.servicecatalog.model.PortfolioDetail(
        id.map(value => value),
        arn.map(value => value),
        displayName.map(value => value),
        description.map(value => value),
        createdTime.map(value => value),
        providerName.map(value => value)
      )
    def id: Optional[Id]
    def arn: Optional[ResourceARN]
    def displayName: Optional[PortfolioDisplayName]
    def description: Optional[PortfolioDescription]
    def createdTime: Optional[CreationTime]
    def providerName: Optional[ProviderName]
    def getId: ZIO[Any, AwsError, Id] = AwsError.unwrapOptionField("id", id)
    def getArn: ZIO[Any, AwsError, ResourceARN] =
      AwsError.unwrapOptionField("arn", arn)
    def getDisplayName: ZIO[Any, AwsError, PortfolioDisplayName] =
      AwsError.unwrapOptionField("displayName", displayName)
    def getDescription: ZIO[Any, AwsError, PortfolioDescription] =
      AwsError.unwrapOptionField("description", description)
    def getCreatedTime: ZIO[Any, AwsError, CreationTime] =
      AwsError.unwrapOptionField("createdTime", createdTime)
    def getProviderName: ZIO[Any, AwsError, ProviderName] =
      AwsError.unwrapOptionField("providerName", providerName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.PortfolioDetail
  ) extends zio.aws.servicecatalog.model.PortfolioDetail.ReadOnly {
    override val id: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.servicecatalog.model.primitives.Id(value))
    override val arn: Optional[ResourceARN] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.servicecatalog.model.primitives.ResourceARN(value))
    override val displayName: Optional[PortfolioDisplayName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.displayName())
        .map(value =>
          zio.aws.servicecatalog.model.primitives.PortfolioDisplayName(value)
        )
    override val description: Optional[PortfolioDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.servicecatalog.model.primitives.PortfolioDescription(value)
        )
    override val createdTime: Optional[CreationTime] = zio.aws.core.internal
      .optionalFromNullable(impl.createdTime())
      .map(value => zio.aws.servicecatalog.model.primitives.CreationTime(value))
    override val providerName: Optional[ProviderName] = zio.aws.core.internal
      .optionalFromNullable(impl.providerName())
      .map(value => zio.aws.servicecatalog.model.primitives.ProviderName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.PortfolioDetail
  ): zio.aws.servicecatalog.model.PortfolioDetail.ReadOnly = new Wrapper(impl)
}
