package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.servicecatalog.model.primitives.{
  AcceptLanguage,
  ProvisioningArtifactName,
  ProductViewName,
  PortfolioDisplayName,
  Id
}
import scala.jdk.CollectionConverters._
final case class DescribeProvisioningParametersRequest(
    acceptLanguage: Optional[AcceptLanguage] = Optional.Absent,
    productId: Optional[Id] = Optional.Absent,
    productName: Optional[ProductViewName] = Optional.Absent,
    provisioningArtifactId: Optional[Id] = Optional.Absent,
    provisioningArtifactName: Optional[ProvisioningArtifactName] =
      Optional.Absent,
    pathId: Optional[Id] = Optional.Absent,
    pathName: Optional[PortfolioDisplayName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.DescribeProvisioningParametersRequest = {
    import DescribeProvisioningParametersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.DescribeProvisioningParametersRequest
      .builder()
      .optionallyWith(
        acceptLanguage.map(value =>
          AcceptLanguage.unwrap(value): java.lang.String
        )
      )(_.acceptLanguage)
      .optionallyWith(
        productId.map(value => Id.unwrap(value): java.lang.String)
      )(_.productId)
      .optionallyWith(
        productName.map(value =>
          ProductViewName.unwrap(value): java.lang.String
        )
      )(_.productName)
      .optionallyWith(
        provisioningArtifactId.map(value => Id.unwrap(value): java.lang.String)
      )(_.provisioningArtifactId)
      .optionallyWith(
        provisioningArtifactName.map(value =>
          ProvisioningArtifactName.unwrap(value): java.lang.String
        )
      )(_.provisioningArtifactName)
      .optionallyWith(pathId.map(value => Id.unwrap(value): java.lang.String))(
        _.pathId
      )
      .optionallyWith(
        pathName.map(value =>
          PortfolioDisplayName.unwrap(value): java.lang.String
        )
      )(_.pathName)
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.DescribeProvisioningParametersRequest.ReadOnly =
    zio.aws.servicecatalog.model.DescribeProvisioningParametersRequest
      .wrap(buildAwsValue())
}
object DescribeProvisioningParametersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.DescribeProvisioningParametersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.servicecatalog.model.DescribeProvisioningParametersRequest =
      zio.aws.servicecatalog.model.DescribeProvisioningParametersRequest(
        acceptLanguage.map(value => value),
        productId.map(value => value),
        productName.map(value => value),
        provisioningArtifactId.map(value => value),
        provisioningArtifactName.map(value => value),
        pathId.map(value => value),
        pathName.map(value => value)
      )
    def acceptLanguage: Optional[AcceptLanguage]
    def productId: Optional[Id]
    def productName: Optional[ProductViewName]
    def provisioningArtifactId: Optional[Id]
    def provisioningArtifactName: Optional[ProvisioningArtifactName]
    def pathId: Optional[Id]
    def pathName: Optional[PortfolioDisplayName]
    def getAcceptLanguage: ZIO[Any, AwsError, AcceptLanguage] =
      AwsError.unwrapOptionField("acceptLanguage", acceptLanguage)
    def getProductId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("productId", productId)
    def getProductName: ZIO[Any, AwsError, ProductViewName] =
      AwsError.unwrapOptionField("productName", productName)
    def getProvisioningArtifactId: ZIO[Any, AwsError, Id] = AwsError
      .unwrapOptionField("provisioningArtifactId", provisioningArtifactId)
    def getProvisioningArtifactName
        : ZIO[Any, AwsError, ProvisioningArtifactName] = AwsError
      .unwrapOptionField("provisioningArtifactName", provisioningArtifactName)
    def getPathId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("pathId", pathId)
    def getPathName: ZIO[Any, AwsError, PortfolioDisplayName] =
      AwsError.unwrapOptionField("pathName", pathName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.DescribeProvisioningParametersRequest
  ) extends zio.aws.servicecatalog.model.DescribeProvisioningParametersRequest.ReadOnly {
    override val acceptLanguage: Optional[AcceptLanguage] =
      zio.aws.core.internal
        .optionalFromNullable(impl.acceptLanguage())
        .map(value =>
          zio.aws.servicecatalog.model.primitives.AcceptLanguage(value)
        )
    override val productId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.productId())
      .map(value => zio.aws.servicecatalog.model.primitives.Id(value))
    override val productName: Optional[ProductViewName] = zio.aws.core.internal
      .optionalFromNullable(impl.productName())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.ProductViewName(value)
      )
    override val provisioningArtifactId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.provisioningArtifactId())
      .map(value => zio.aws.servicecatalog.model.primitives.Id(value))
    override val provisioningArtifactName: Optional[ProvisioningArtifactName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.provisioningArtifactName())
        .map(value =>
          zio.aws.servicecatalog.model.primitives
            .ProvisioningArtifactName(value)
        )
    override val pathId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.pathId())
      .map(value => zio.aws.servicecatalog.model.primitives.Id(value))
    override val pathName: Optional[PortfolioDisplayName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pathName())
        .map(value =>
          zio.aws.servicecatalog.model.primitives.PortfolioDisplayName(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.DescribeProvisioningParametersRequest
  ): zio.aws.servicecatalog.model.DescribeProvisioningParametersRequest.ReadOnly =
    new Wrapper(impl)
}
