package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class BatchDisassociateServiceActionFromProvisioningArtifactResponse(
    failedServiceActionAssociations: Optional[
      Iterable[zio.aws.servicecatalog.model.FailedServiceActionAssociation]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.BatchDisassociateServiceActionFromProvisioningArtifactResponse = {
    import BatchDisassociateServiceActionFromProvisioningArtifactResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.BatchDisassociateServiceActionFromProvisioningArtifactResponse
      .builder()
      .optionallyWith(
        failedServiceActionAssociations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.failedServiceActionAssociations)
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.BatchDisassociateServiceActionFromProvisioningArtifactResponse.ReadOnly =
    zio.aws.servicecatalog.model.BatchDisassociateServiceActionFromProvisioningArtifactResponse
      .wrap(buildAwsValue())
}
object BatchDisassociateServiceActionFromProvisioningArtifactResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.BatchDisassociateServiceActionFromProvisioningArtifactResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.servicecatalog.model.BatchDisassociateServiceActionFromProvisioningArtifactResponse =
      zio.aws.servicecatalog.model
        .BatchDisassociateServiceActionFromProvisioningArtifactResponse(
          failedServiceActionAssociations.map(value =>
            value.map { item =>
              item.asEditable
            }
          )
        )
    def failedServiceActionAssociations: Optional[
      List[zio.aws.servicecatalog.model.FailedServiceActionAssociation.ReadOnly]
    ]
    def getFailedServiceActionAssociations: ZIO[Any, AwsError, List[
      zio.aws.servicecatalog.model.FailedServiceActionAssociation.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "failedServiceActionAssociations",
      failedServiceActionAssociations
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.BatchDisassociateServiceActionFromProvisioningArtifactResponse
  ) extends zio.aws.servicecatalog.model.BatchDisassociateServiceActionFromProvisioningArtifactResponse.ReadOnly {
    override val failedServiceActionAssociations: Optional[
      List[zio.aws.servicecatalog.model.FailedServiceActionAssociation.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.failedServiceActionAssociations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.servicecatalog.model.FailedServiceActionAssociation.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.BatchDisassociateServiceActionFromProvisioningArtifactResponse
  ): zio.aws.servicecatalog.model.BatchDisassociateServiceActionFromProvisioningArtifactResponse.ReadOnly =
    new Wrapper(impl)
}
