package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.servicecatalog.model.primitives.CausingEntity
import scala.jdk.CollectionConverters._
final case class ResourceChangeDetail(
    target: Optional[zio.aws.servicecatalog.model.ResourceTargetDefinition] =
      Optional.Absent,
    evaluation: Optional[zio.aws.servicecatalog.model.EvaluationType] =
      Optional.Absent,
    causingEntity: Optional[CausingEntity] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.ResourceChangeDetail = {
    import ResourceChangeDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.ResourceChangeDetail
      .builder()
      .optionallyWith(target.map(value => value.buildAwsValue()))(_.target)
      .optionallyWith(evaluation.map(value => value.unwrap))(_.evaluation)
      .optionallyWith(
        causingEntity.map(value =>
          CausingEntity.unwrap(value): java.lang.String
        )
      )(_.causingEntity)
      .build()
  }
  def asReadOnly: zio.aws.servicecatalog.model.ResourceChangeDetail.ReadOnly =
    zio.aws.servicecatalog.model.ResourceChangeDetail.wrap(buildAwsValue())
}
object ResourceChangeDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.ResourceChangeDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicecatalog.model.ResourceChangeDetail =
      zio.aws.servicecatalog.model.ResourceChangeDetail(
        target.map(value => value.asEditable),
        evaluation.map(value => value),
        causingEntity.map(value => value)
      )
    def target: Optional[
      zio.aws.servicecatalog.model.ResourceTargetDefinition.ReadOnly
    ]
    def evaluation: Optional[zio.aws.servicecatalog.model.EvaluationType]
    def causingEntity: Optional[CausingEntity]
    def getTarget: ZIO[
      Any,
      AwsError,
      zio.aws.servicecatalog.model.ResourceTargetDefinition.ReadOnly
    ] = AwsError.unwrapOptionField("target", target)
    def getEvaluation
        : ZIO[Any, AwsError, zio.aws.servicecatalog.model.EvaluationType] =
      AwsError.unwrapOptionField("evaluation", evaluation)
    def getCausingEntity: ZIO[Any, AwsError, CausingEntity] =
      AwsError.unwrapOptionField("causingEntity", causingEntity)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.ResourceChangeDetail
  ) extends zio.aws.servicecatalog.model.ResourceChangeDetail.ReadOnly {
    override val target: Optional[
      zio.aws.servicecatalog.model.ResourceTargetDefinition.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.target())
      .map(value =>
        zio.aws.servicecatalog.model.ResourceTargetDefinition.wrap(value)
      )
    override val evaluation
        : Optional[zio.aws.servicecatalog.model.EvaluationType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.evaluation())
        .map(value => zio.aws.servicecatalog.model.EvaluationType.wrap(value))
    override val causingEntity: Optional[CausingEntity] = zio.aws.core.internal
      .optionalFromNullable(impl.causingEntity())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.CausingEntity(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.ResourceChangeDetail
  ): zio.aws.servicecatalog.model.ResourceChangeDetail.ReadOnly = new Wrapper(
    impl
  )
}
